import './assets/main.css'

import { createApp } from 'vue'
import { createPinia } from 'pinia'

import ElementPlus from 'element-plus'
import 'element-plus/dist/index.css'

import App from './App.vue'
import router from './router'
import Vant, { ConfigProvider } from 'vant'

import 'font-awesome/css/font-awesome.min.css'

const app = createApp(App)
app.use(ElementPlus)
app.use(createPinia())
app.use(router).use(Vant).use(ConfigProvider)

app.mount('#app')
