import { createRouter, createWebHashHistory } from 'vue-router'

const router = createRouter({
  history: createWebHashHistory(import.meta.env.BASE_URL),
  routes: [
    {
      path: '/',
      redirect: 'members/index'
    },
    {
      path: '/members',
      component: () => import('../views/main/main.vue'),
      children: [
        {
          path: 'index',
          component: () => import('../views/members/members.vue'),
          name: 'members',
          meta: {
            KeepAlive: true
          }
        },
        {
          path: 'detail',
          component: () => import('../views/members/detail.vue'),
          name: 'detail'
        },
        {
          path: 'coin',
          component: () => import('../views/members/coin.vue'),
          name: 'coin'
        },
        {
          path: 'staking',
          component: () => import('../views/members/staking.vue'),
          name: 'staking'
        },
        {
          path: 'code',
          component: () => import('../views/members/code.vue'),
          name: 'code'
        },
        {
          path: 'addCode',
          component: () => import('../views/members/addCode.vue'),
          name: 'addCode'
        },
        {
          path: 'money_history',
          component: () => import('../views/members/money_history.vue'),
          name: 'money_history'
        },
      ]
    },
    {
      path: '/staking',
      component: () => import('../views/main/main.vue'),
      children: [
        {
          path: 'product',
          component: () => import('../views/staking/product.vue'),
          name: 'product'
        },
        {
          path: 'history',
          component: () => import('../views/staking/history.vue'),
          name: 'history'
        },
        {
          path: 'user',
          component: () => import('../views/staking/user.vue'),
          name: 'user'
        },
        {
          path: 'reward',
          component: () => import('../views/staking/reward.vue'),
          name: 'reward'
        },
        {
          path: 'detail',
          component: () => import('../views/staking/detail.vue'),
          name: 'stakingDetail'
        }
      ]
    },
    {
      path: '/login',
      name: 'login',
      component: () => import('../views/login/login.vue')
    }
  ],
})

export default router
