import { ref, computed } from 'vue'
import { defineStore } from 'pinia'
import { useRouter } from 'vue-router'

export const useCounterStore = defineStore('counter', () => {
  const count = ref(0)
  const doubleCount = computed(() => count.value * 2)
  function increment() {
    count.value++
  }
  const router = useRouter()
  
  const keepDefaultList = ref(['MemberIndex', 'MoneyHistory', 'product', 'StakingUser', 'StakingHistory', 'StakingReward'])

  const keepList = ref(['MemberIndex', 'MoneyHistory', 'product', 'StakingUser', 'StakingHistory', 'StakingReward'])

  return { count, doubleCount, increment, router, keepList, keepDefaultList }
})
