// 前往下一个页面
export function goPage(e: string) {
  uni.navigateTo({
    url: e
  })
}

// 返回下一个页面
export function goBack(delta: number = 1) {
  uni.navigateBack({
    delta
  })
}

// 删除当前页并前往下一个页面
export function reLaunch(e: string) {
  uni.reLaunch({
    url: e
  })
}

// 跳转到tabbar
export function switchTab(e: string) {
  uni.switchTab({
    url: e
  })
}

// 时间戳转换
export const timestempToDate = (timestamp: number, n: string = '-') => {
  const date = new Date(timestamp + 3600000 * 9)
  const year = date.getUTCFullYear()
  const month = date.getUTCMonth() - 1 < 10 ? `0${date.getUTCMonth() - 1}` : date.getUTCMonth() - 1
  const day = date.getUTCDate() < 10 ? `0${date.getUTCDate()}` : date.getUTCDate()
  const hour = date.getUTCHours() < 10 ? `0${date.getUTCHours()}` : date.getUTCHours()
  const minute = date.getUTCMinutes() < 10 ? `0${date.getUTCMinutes()}` : date.getUTCMinutes()
  return `${year}${n}${month}${n}${day} ${hour}:${minute}`
}

export function timestampToDate2(input: number | string): string {
  let date: Date

  if (typeof input === 'number') {
    // 判断是否为秒级时间戳（小于13位）
    if (input.toString().length <= 10) {
      input = input * 1000
    }
    date = new Date(input + 3600000 * 9) // 加 9 小时
  } else if (typeof input === 'string') {
    const parsed = new Date(input)
    if (isNaN(parsed.getTime())) {
      return 'Invalid Date'
    }
    date = new Date(parsed.getTime() + 3600000 * 9)
  } else {
    return 'Invalid Input'
  }

  const year = date.getUTCFullYear()
  const month = String(date.getUTCMonth() + 1).padStart(2, '0')
  const day = String(date.getUTCDate()).padStart(2, '0')
  const hours = String(date.getUTCHours()).padStart(2, '0')
  const minutes = String(date.getUTCMinutes()).padStart(2, '0')
  const seconds = String(date.getUTCSeconds()).padStart(2, '0')

  return `${year}-${month}-${day} ${hours}:${minutes}:${seconds}`
}

// 获取股票颜色
export const getColor = (item: any, type: boolean = false) => {
  if (type && item.zhangdiebaifenbi > 0) {
    return 'up rotate'
  }
  return item.zhangdiebaifenbi > 0 ? 'up' : item.zhangdiebaifenbi === 0 ? 'ping' : 'down'
}

// 验证输入框内容是否为空
interface checkType {
  key: string
  message: string
}
interface dataType {
  [key: string]: string | null
}
export function checkInput(checkArr: Array<checkType>, data: dataType) {
  for (const i in checkArr) {
    if (!data[checkArr[i].key]) {
      uni.showToast({
        title: checkArr[i].message,
        icon: 'none'
      })
      return false
    }
  }
  return true
}

// 价格转换（加逗号）
export const changeMoney = (money: any) => {
  money = Number(money).toFixed(1)
  money += ''
  const x = money.split('.')
  let x1 = x[0]
  const x2 = x.length > 1 ? '.' + x[1] : ''
  const reg = /(\d+)(\d{3})/
  while (reg.test(x1)) {
    x1 = x1.replace(reg, '$1' + ',' + '$2')
  }
  return x1 + x2
}
