package com.flyco.tablayout.utils

import androidx.fragment.app.Fragment
import androidx.fragment.app.FragmentActivity
import androidx.fragment.app.FragmentManager
import androidx.lifecycle.Lifecycle
import androidx.viewpager2.adapter.FragmentStateAdapter
import java.util.ArrayList

/**
 * @author by Dell
 * @date on 2021/8/18
 * @describe
 */
class FragmentBasePager2Adapter(fm: FragmentManager?, fragments: ArrayList<Fragment>?, titles: Array<String?>,lifecycle: Lifecycle) : FragmentStateAdapter(fm!!, lifecycle) {
    private var mFragments: ArrayList<Fragment>? = arrayListOf()
    private var mTitles: Array<String?>? = null

    override fun getItemCount(): Int {
        return mFragments?.size ?: 0
    }

    override fun createFragment(position: Int): Fragment {
        return mFragments!![position]
    }

    fun getPageTitle(position: Int): CharSequence? {
        return mTitles!![position]
    }

    fun getItem(position: Int): Fragment {
        return mFragments!![position]
    }

    init {

        titles.isNotEmpty().let {
            if (it) {
                mTitles = titles
            }

        }
        fragments?.isNotEmpty()?.let {
            if (it) {
                mFragments = fragments
            }
        }
    }
}