package com.hupu.tv.player.app.api

import com.google.gson.Gson
import com.google.gson.JsonIOException
import com.google.gson.TypeAdapter
import com.google.gson.stream.JsonToken
import com.softgarden.baselibrary.network.ApiException
import com.softgarden.baselibrary.network.BaseBean
import com.hupu.tv.player.app.utils.EncodeUtils2
import okhttp3.ResponseBody
import retrofit2.Converter
import java.io.ByteArrayInputStream
import java.io.InputStreamReader
import java.nio.charset.StandardCharsets.UTF_8

class CustomGsonResponseBodyConverter<T>(private val gson: Gson, private val annotations: Array<out Annotation>?, private val adapter: TypeAdapter<T>) : Converter<ResponseBody, T> {

    override fun convert(value: ResponseBody): T {
        var response = value.string()
        val baseBean: BaseBean<String> = gson.fromJson(response, BaseBean::class.java) as BaseBean<String>
        /** 本节无关，异常统一处理，见上篇《Retrofit 2.0的封装与异常处理》**/
        if (baseBean.code != BaseBean.SUCCESS) {
            value.close()
            throw ApiException(baseBean.code, baseBean.msg ?: "")
        }
        if (annotations != null) {
            for (annotation: Annotation in annotations) {
                if (annotation is ResponseProcess) {
//                    val rsadecrypt = EncodeUtils2().rsadecrypt()
                    var string = EncodeUtils2().decode(baseBean.data as String)
                    baseBean.data = ""
                    val toJson = gson.toJson(baseBean)
                    val replace = toJson.replace("data\":\"\"", "data\":$string")
                    response = replace.trim()
                    val contentType = value.contentType()
                    val charset = contentType?.charset(UTF_8) ?: UTF_8
                    val inputStream = ByteArrayInputStream(response.toByteArray())
                    val reader = InputStreamReader(inputStream, charset!!)
                    val jsonReader = gson.newJsonReader(reader)
                    val result = adapter.read(jsonReader)
                    if (jsonReader.peek() != JsonToken.END_DOCUMENT) {
                        throw JsonIOException("JSON document was not fully consumed.")
                    }
                    return result

                }
            }
        }
        val contentType = value.contentType()
        val charset = contentType?.charset(UTF_8) ?: UTF_8
        val inputStream = ByteArrayInputStream(response.toByteArray())
        val reader = InputStreamReader(inputStream, charset!!)
        val jsonReader = gson.newJsonReader(reader)
        val result = adapter.read(jsonReader)
        if (jsonReader.peek() != JsonToken.END_DOCUMENT) {
            throw JsonIOException("JSON document was not fully consumed.")
        }
        return result

    }
}