package com.hupu.tv.player.app.api

import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.network.ApiException
import com.softgarden.baselibrary.network.RxJava3NullException
import com.softgarden.baselibrary.utils.NetworkUtil
import com.hupu.tv.player.app.bean.GankBaseBean
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers
import io.reactivex.rxjava3.core.Observable
import io.reactivex.rxjava3.core.ObservableSource
import io.reactivex.rxjava3.core.ObservableTransformer
import io.reactivex.rxjava3.disposables.Disposable
import io.reactivex.rxjava3.functions.Consumer
import io.reactivex.rxjava3.functions.Predicate
import io.reactivex.rxjava3.schedulers.Schedulers


/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe
 * RxJava2 转换器 用于网络加载数据 已实现功能有：
 *
 *
 * 1.检测有无网络
 * 2.加载网络时显示加载框 结束是隐藏
 * 3.控制RxJava生命周期，防止内存泄漏
 */
class GankNetworkTransformer<T> @JvmOverloads constructor(mView: IBaseDisplay?, showLoading: Boolean = true) : ObservableTransformer<GankBaseBean<T>, T> {
    private val mView: IBaseDisplay
    private val showLoading: Boolean
    override fun apply(upstream: Observable<GankBaseBean<T>>): ObservableSource<T> {
        return upstream
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .doOnSubscribe { disposable: Disposable ->
                    //请求前检测网络
                    if (!NetworkUtil.isConnected(mView.ctx)) {
                        NetworkUtil.showNoNetWorkDialog(mView.ctx)
                        mView.onRequestFinish()
                        disposable.dispose()
                    } else {
                        if (showLoading) mView.showProgressDialog()
                    }
                }
                .doFinally {
                    if (showLoading) mView.hideProgressDialog()
                    mView.onRequestFinish()
                }
                .filter(filterData())
                .filter(checkInnerData())
                .map {
                    it.results
                }
                .doOnError(Consumer { throwable: Throwable ->
                    //RxJava2NullException 交给RxCallback处理
                    if (throwable !is RxJava3NullException) {
                        mView.showError(throwable,true)
                    }
                })
                .compose(mView.bindToLifecycle())
    }



    /**
     * 过滤异常
     *
     * @return
     */
    fun <T>filterData(): Predicate<in GankBaseBean<T>> {
        return Predicate<GankBaseBean<T>> {
            if (!it.error) {
                return@Predicate true
            } else {
                //                if (baseBean.status == -1) {
//                    mView.showReLoginDialog();
//                }
                throw ApiException("1", "请求失败")
            }
        }
    }
    /**
     * 提取内部真正数据，并检测数据是否为空
     *
     * @return
     */
    fun <T>checkInnerData(): Predicate<in GankBaseBean<T>> {
        return Predicate<GankBaseBean<T>> {
            if (it.results != null) return@Predicate true
            throw RxJava3NullException()
        }
    }


    init {
        if (mView == null) throw RuntimeException("IBaseDisplay is not NULL")
        this.mView = mView
        this.showLoading = showLoading
    }
}