package com.hupu.tv.player.app.api

import android.text.TextUtils
import com.hupu.tv.player.app.BuildConfig

import com.softgarden.baselibrary.utils.L
import com.softgarden.baselibrary.utils.MD5Util
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.app.Constants
import okhttp3.*
import okio.Buffer
import org.json.JSONException
import org.json.JSONObject
import java.io.IOException

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe
 * 参数格式为Json格式的拦截器
 */
class ParameterInterceptor : Interceptor {
    @Throws(IOException::class)
    override fun intercept(chain: Interceptor.Chain): Response {
        val oldRequest = chain.request()
        val requestBody = makeRequestBody(oldRequest)
        val httpUrl = oldRequest.url().newBuilder().build()
        val newRequest = oldRequest.newBuilder()
                .url(httpUrl)
                //              .addHeader("Content-Type", "application/json")
                //              .addHeader("Accept", " application/json")//添加header
                .addHeader(Constants.DEVICE_ID, SPUtil.get(Constants.DEVICE_ID,"") as String)
                .addHeader(Constants.TOKEN, SPUtil.get(Constants.TOKEN,"") as String)
                .post(requestBody)
                .build()
        var response = chain.proceed(newRequest)
        //打印返回数据
        if (BuildConfig.DEBUG) {
            val resultBody = response.body()
            val result = resultBody?.string()
            try {
                L.json(result)
            } catch (e: Exception) {
                L.e(result)
            }
            /*** 因为调用ResponseBody.string()后即关闭，后续无法获取内容  */
            response = response.newBuilder()
                    .body(ResponseBody.create(resultBody?.contentType(), result))
                    .build()
        }
        return response
    }

    private fun makeRequestBody(oldRequest: Request): RequestBody {
        val oldUrl = oldRequest.url()
        var data = JSONObject()
        try {
            if (oldRequest.body() is FormBody) {
                /*** 当参数以 @Field @FieldMap 提交时  */
                L.d(TAG, "instanceof FormBody")
                val body = oldRequest.body() as FormBody?
                if (body != null) for (i in body.size() - 1 downTo 0) {
                    val name = body.name(i)
                    val value = body.value(i)
                    data.put(name, value)
                }
            } else if (oldRequest.body() is MultipartBody) {
                /*** 当参数以 @MultipartBody 提交时  */
                L.d(TAG, "instanceof MultipartBody")
            } else {
                /*** 当参数以 @Body 提交时  */
                val bodyString = bodyToString(oldRequest.body())
                if (!TextUtils.isEmpty(bodyString)) {
                    data = JSONObject(bodyString)
                    L.d("bodyToString---", bodyString)
                }
            }

//            /** 链接上的参数 放在最后 */
//            for (int i = oldUrl.querySize() - 1; i >= 0; i--) {
//                String name = oldUrl.queryParameterName(i);
//                String value = oldUrl.queryParameterValue(i);
//                data.put(name, value);
//            }
//            data.put("orgin", "0");
            /**
             * 统一加入参数
             */
//            String userId = SPManager.getUserId();
//            if (!TextUtils.isEmpty(userId)) {
//                data.put("user_id", userId);
//                data.put("token", SPManager.getToken());
//
//            }
        } catch (e: JSONException) {
            e.printStackTrace()
        }
        /** * 添加Sign参数  */
        val newBodyBuilder = FormBody.Builder()
        newBodyBuilder.add("data", data.toString())
        newBodyBuilder.add("apisign", MD5Util.ToMD5(Constants.MD5_KEY, data.toString()))
        L.d("请求地址RequestUrl=====", oldUrl.url().toString())
        L.d("请求参数Params=========", data.toString()) //打印请求log
        L.json(data.toString())
        return newBodyBuilder.build()
    }

    /**
     * body 中的内容
     *
     * @param request
     * @return
     */
    private fun bodyToString(request: RequestBody?): String {
        return try {
            val buffer = Buffer()
            if (request != null) request.writeTo(buffer) else return ""
            buffer.readUtf8()
        } catch (e: IOException) {
            "did not work"
        }
    }

    companion object {
        private val TAG = ParameterInterceptor::class.java.simpleName
    }
}