package com.hupu.tv.player.app.api

import com.softgarden.baselibrary.utils.L
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.app.Constants
import okhttp3.OkHttpClient
import retrofit2.Retrofit
import retrofit2.adapter.rxjava3.RxJava3CallAdapterFactory

import java.util.concurrent.TimeUnit

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe
 * Retrofit 获取单列
 */
object RetrofitClient {
    private var retrofit: Retrofit? = null
    val instance: Retrofit?
        get() {
            if (retrofit == null) synchronized(RetrofitClient::class.java) {
                if (retrofit == null) {
                    retrofit = get()
                }
            }
            return retrofit
        }

    //设置超时
    //错误重连
    //需要对请求参数进行处理的时候添加
//       .addInterceptor(new ParameterInterceptor())// 拦截器
    private val okHttpClient: OkHttpClient
        get() {
            val builder = OkHttpClient.Builder() //设置超时
                    .connectTimeout(15, TimeUnit.SECONDS)
                    .readTimeout(20, TimeUnit.SECONDS)
                    .writeTimeout(20, TimeUnit.SECONDS) //错误重连
                    .retryOnConnectionFailure(false) //需要对请求参数进行处理的时候添加
//                    .addInterceptor(ParameterInterceptor())// 拦截器
                    .addInterceptor(loggingInterceptor)
            return builder.build()
        }


    private val loggingInterceptor = LoggingInterceptor(LoggingInterceptor.Logger { message ->
        //打印retrofit日志
        L.w("RetrofitLog", message + "")
    }).setLevel(LoggingInterceptor.Level.BODY)


    fun get(): Retrofit {
        return Retrofit.Builder().baseUrl(SPUtil[Constants.HOST_URL,HostUrl.HOST_URL] as String)
                .addCallAdapterFactory(RxJava3CallAdapterFactory.create())
                .addConverterFactory(CustomGsonConverterFactory.create())
                .client(okHttpClient)
                .build()
    }

    private fun <T> getAPIService(service: Class<T>?): T {
        return instance!!.create(service)
    }

    val retrofitService: RetrofitService
        get() = getAPIService(RetrofitService::class.java)
}