package com.hupu.tv.player.app.api

import com.softgarden.baselibrary.network.BaseBean
import com.hupu.tv.player.app.bean.*
import com.hupu.tv.player.app.utils.ProductFlavors
import io.reactivex.rxjava3.core.Observable

import okhttp3.MultipartBody
import okhttp3.RequestBody
import okhttp3.ResponseBody
import retrofit2.http.*

interface RetrofitService {/*@Field("is_new") int is_new*/
    /**
     * 测试接口
     */
    //接口有参数时 要写上该注解
    // @FormUrlEncoded
    @get:POST(HostUrl.POST_LIST_AD)
    val data: Observable<BaseBean<List<ImageBean>>>

    /**
     * 测试接口
     */
    @GET(HostUrl.POST_LIST_AD)
    fun getImages(@Path("page") page: Int, @Path("pageSize") pageSize: Int): Observable<GankBaseBean<List<ImageBean>>>

    /**
     * 测试接口
     */
    @POST
    fun getData(@Url url: String? /*@Field("is_new") int is_new*/): Observable<BaseBean<List<ImageBean>>>

    /**
     * 广告接口
     */
    @POST(HostUrl.POST_LIST_AD)
    fun getAdList(): Observable<BaseBean<List<AdBean>>>

    /**
     * 更新APP
     */
    @POST(HostUrl.POST_UPDATE_LINK)
    fun updateApp(@Body requestBody: RequestBody): Observable<BaseBean<UpdateBean>>

    @POST(HostUrl.POST_LIVE_OTHER)
    fun liveOther(@Body requestBody: RequestBody): Observable<BaseBean<LiveBean>>

    @POST(HostUrl.POST_LIVE_BASKETBALL)
    fun liveBasketBall(@Body requestBody: RequestBody): Observable<BaseBean<LiveBean>>

    @POST(HostUrl.POST_LIVE_TOP_OTHER)
    fun liveAllType(@Body requestBody: RequestBody): Observable<BaseBean<LiveBean>>

    @POST(HostUrl.POST_LIVE_HOT)
    fun liveHot(@Body requestBody: RequestBody): Observable<BaseBean<LiveBean>>

    @POST(HostUrl.POST_LIVE_HOT_TOP)
    fun liveHotTop(@Body requestBody: RequestBody): Observable<BaseBean<MatchContentBean>>

    @POST(HostUrl.POST_LIVE_FOOTBALL)
    fun liveFootball(@Body requestBody: RequestBody): Observable<BaseBean<LiveBean>>

    /**
     * 获取头像地址
     */
    @POST(HostUrl.POST_GET_AVATAR_URL)
    fun getAvatarUrl(): Observable<BaseBean<String>>

    /**
     * 是否显示配置
     */
    @POST(HostUrl.POST_GET_LIVE_CONFIG)
    fun getLiveConfig(): Observable<BaseBean<ShowConifgEntity>>

    /**
     * 获取首页banner
     */
    @POST(HostUrl.POST_LIVE_BANNER)
    fun getBannerList(@Body body: RequestBody): Observable<BaseBean<ArrayList<BannerBean>>>

    /**
     * 获取首页banner
     */
    @POST(HostUrl.ADD_DOWNLOAD)
    fun addDownNum(@Header("api-channel") umChannel: String = ProductFlavors.getString(ProductFlavors.UM_CHANNEL_ID)): Observable<BaseBean<Any>>

    /**
     * 获取有料banner
     */
    @POST(HostUrl.FEATURED_EXPERTS_LIST)
    fun getSpecialist(@Body body: RequestBody): Observable<BaseBean<MutableList<SpecialistBean>>>

    /**
     * 获取有料焦点赛程
     */
    @POST(HostUrl.POST_HOT_RANK_LIST)
    fun getMaterialSchedule(@Body body: RequestBody): Observable<BaseBean<MaterialScheduleEntity>>

    /**
     * 获取足球和篮球的有料
     */
    @POST(HostUrl.HOT_RANK_BALL)
    fun getBallMaterial(@Body body: RequestBody): Observable<BaseBean<SpecialBallBean>>

    @GET(HostUrl.GET_SEND_MESSAGE)
    fun sendMessage(@Query("chat_id") charId: Int, @Query("text") text: String): retrofit2.Call<ResponseBody>

    /**
     * 公告接口
     */
    @POST(HostUrl.POST_BOARD_AD)
    fun getBoardList(): Observable<BaseBean<List<BoardBean>>>

    /**
     * 活动接口
     */
    @POST(HostUrl.POST_LIST_ICON)
    fun getIconList(@Body requestBody: RequestBody): Observable<BaseBean<List<IconBean>>>

    /**
     * 中奖接口
     */
    @POST(HostUrl.POST_WINNER)
    fun getWinnerList(): Observable<BaseBean<List<String>>>

    /**
     * 购买影片支付接口
     */
    @POST(HostUrl.POST_MOVIE_BUY_GOLD)
    fun buyMovie(@Body requestBody: RequestBody): Observable<BaseBean<String>>

    /**
     * 中奖接口
     */
    @POST(HostUrl.POST_WINNER)
    fun getWinnerListParam(@Body requestBody: RequestBody): Observable<BaseBean<List<String>>>

    /**
     * 登录接口
     */
    @POST(HostUrl.POST_LOGIN)
    fun login(@Body requestBody: RequestBody): Observable<BaseBean<UserBean>>

    /**
     * 登录接口
     */
    @POST(HostUrl.POST_LOGIN_LIVE)
    fun loginLive(@Body requestBody: RequestBody): Observable<BaseBean<String>>

    /**
     * 注册接口
     */
    @POST(HostUrl.USER_REGISTER)
    fun register(
        @Body requestBody: RequestBody,
        @Header("api-channel") umChannel: String = ProductFlavors.getString(ProductFlavors.UM_CHANNEL_ID)
    ): Observable<BaseBean<String>>

    /**
     * 登录接口
     */
    @POST(HostUrl.POST_LOGIN_PASSWORD)
    fun loginPassword(@Body requestBody: RequestBody): Observable<BaseBean<String>>


    /**
     * 登录接口
     */
    @POST(HostUrl.POST_FEEDBACK)
    fun feedBack(@Body requestBody: RequestBody): Observable<BaseBean<String>>


    /**
     * 登录接口
     */
    @FormUrlEncoded
    @POST(HostUrl.POST_TEST)
    fun postTest(@Field("phone") phone: String, @Field("password") password: String): Observable<BaseBean<String>>

    /**
     * 登录接口
     */
    @POST(HostUrl.POST_FEEDBACK_LIST)
    fun getFeedBackList(): Observable<BaseBean<String>>

    /**
     * 登录接口
     */
    @POST(HostUrl.POST_FEEDBACK_TYPE)
    fun getFeedBackTypeList(): Observable<BaseBean<String>>


    /**
     * 登录接口
     */
    @POST(HostUrl.POST_USER_CODE)
    fun getSmsCode(@Body requestBody: RequestBody): Observable<BaseBean<String>>


    /**
     * 登录接口
     */
    @POST(HostUrl.POST_USER_FORGET_PASSWORD)
    fun forgetPassword(@Body requestBody: RequestBody): Observable<BaseBean<String>>

    /**
     * 登录接口
     */
    @POST(HostUrl.POST_USER_SETTING_PASSWORD)
    fun settingPassword(@Body requestBody: RequestBody): Observable<BaseBean<String>>


    /**
     * 登录接口
     */
    @POST(HostUrl.POST_VERIFICATION_SMS_CODE)
    fun verficationSmsCode(@Body requestBody: RequestBody): Observable<BaseBean<String>>

    /**
     * 播放历史
     */
    @POST(HostUrl.POST_MOVIE_HISTORY)
    fun getMovieHistory(@Body requestBody: RequestBody): Observable<BaseBean<MovieBean>>

    /**
     * 付款结果查询
     */
    @POST(HostUrl.POST_PAY_RESULT)
    fun getPayResult(@Body requestBody: RequestBody): Observable<BaseBean<String>>

    /**
     * 钱包明细
     */
    @POST(HostUrl.POST_GET_RECHARGE_FLOW)
    fun getWalletDetail(@Body requestBody: RequestBody): Observable<BaseBean<WalletDetailBean>>

    /**
     * 发送验证码
     */
    @POST(HostUrl.POST_SEND_VERIFY)
    fun getVerifyCode(@Body requestBody: RequestBody): Observable<BaseBean<String>>

    /**
     * 绑定手机
     */
    @POST(HostUrl.POST_VERIFY_CODE)
    fun bindPhone(@Body requestBody: RequestBody): Observable<BaseBean<String>>

    /**
     * 获取更多历史
     */
    @POST(HostUrl.POST_MOVIE_HISTORY_MORE)
    fun getMovieHistoryMore(@Body requestBody: RequestBody): Observable<BaseBean<MovieBean>>

    /**
     * 电影详情des，aes加密
     */
    @POST(HostUrl.POST_MOVIE_DETAIL)
    @ResponseProcess(MovieResponseConverter::class)
    fun getMovieDetail(@Body requestBody: RequestBody): Observable<BaseBean<MovieDetailBean>>

    /**
     * vip的列表
     */
    @POST(HostUrl.POST_PAY_TYPE)
    fun getVipType(): Observable<BaseBean<List<PayTypeBean>>>

    /**
     * 获取金币列表
     */
    @GET(HostUrl.POST_PAY_COIN_LIST)
    fun getCoinList(): Observable<BaseBean<List<CoinBean>>>

    /**
     * 付款列表
     */
    @POST(HostUrl.POST_VIP_LIST)
    fun getPayVipType(): Observable<BaseBean<List<PayVipTypeBean>>>

    /**
     * 付款列表
     */
    @POST(HostUrl.POST_RECHARGE)
    fun getPayRecord(): Observable<BaseBean<List<String>>>


    /**
     * 赛事标题列表
     */
    @POST(HostUrl.Companion.POST_MATCH_TITLE)
    fun getMatchTitle(): Observable<BaseBean<List<TitleSortBean>>>


    /**
     * 获取赛事相关新闻
     */
    @POST(HostUrl.Companion.POST_MATCH_NEWS)
    fun getMatchNews(@Body requestBody: RequestBody): Observable<BaseBean<NewsDataBean>>

    /**
     * 赛事列表
     */
    @POST(HostUrl.POST_MATCH_LIST_NEW)
    fun getMatchList(@Body requestBody: RequestBody): Observable<BaseBean<MatchContentEntity>>


    /**
     * 赛事详情
     */
    @POST(HostUrl.Companion.POST_MATCH_INFO)
    fun getMatchDetail(@Body requestBody: RequestBody): Observable<BaseBean<MatchDetailBean>>

    /**
     * 主播列表
     */
    @POST(HostUrl.Companion.POST_MATCH_USER_ANCHOR)
    fun getMatchAnchor(): Observable<BaseBean<List<AnchorEntity>>>

    /**
     * 赛事列表
     */
    @POST(HostUrl.Companion.POST_MATCH_USER_MATCH)
    fun getMatchReserve(): Observable<BaseBean<MatchContentEntity>>


    /**
     * 关注主播
     */
    @POST(HostUrl.Companion.POST_MATCH_FOLLOW_ANCHOR)
    fun followAnchor(@Body requestBody: RequestBody): Observable<BaseBean<String>>

    /**
     * 取消关注主播
     */
    @POST(HostUrl.Companion.POST_MATCH_UN_FOLLOW_ANCHOR)
    fun unfollowAnchor(@Body requestBody: RequestBody): Observable<BaseBean<String>>

    /**
     * 取消关注主播
     */
    @POST(HostUrl.Companion.POST_LIVE_RECOMMEND_LIST)
    fun getRecommendList(@Body requestBody: RequestBody): Observable<BaseBean<LiveBean>>


    /**
     * 预约赛事
     */
    @POST(HostUrl.Companion.POST_MATCH_RESERVE_MATCH)
    fun reserveMatch(@Body requestBody: RequestBody): Observable<BaseBean<String>>

    /**
     * 取消预约赛事
     */
    @POST(HostUrl.Companion.POST_MATCH_CANCEL_RESERVE_MATCH)
    fun cancelReserve(@Body requestBody: RequestBody): Observable<BaseBean<String>>


    /**
     * 获取首页分类列表
     */
    @POST(HostUrl.Companion.POST_MAIN_CATEGORY)
    fun getMainMovieCategory(): Observable<BaseBean<List<CategoryBean>>>

    /**
     * 系统配置
     */
    @POST(HostUrl.Companion.POST_SYSTEM_CONFIG)
    fun getSystemInfo(): Observable<BaseBean<List<SystemBean>>>

    /**
     * 系统配置
     */
    @POST(HostUrl.Companion.POST_LIST_TAG)
    fun getSearchTag(): Observable<BaseBean<List<SearchTagBean>>>

    /**
     * 电影接口des,aes加密
     */
    @POST(HostUrl.Companion.POST_MOVIE_LIST)
    @ResponseProcess(MovieResponseConverter::class)
    fun getMovieList(@Body requestBody: RequestBody): Observable<BaseBean<MovieBean>>


    @POST(HostUrl.Companion.POST_MOVIE_LIST_NEW)
    @ResponseProcess(MovieResponseConverter::class)
    fun getMainMovieList(@Body requestBody: RequestBody): Observable<BaseBean<MovieBean>>


    @POST(HostUrl.Companion.POST_MOVIE_LIST_SORT)
    @ResponseProcess(MovieResponseConverter::class)
    fun getSortMovieList(@Body requestBody: RequestBody): Observable<BaseBean<MovieBean>>


    /**
     * 获取tikTok
     */
    @POST(HostUrl.Companion.POST_MOVIE_TIK_TOK)
    @ResponseProcess(MovieResponseConverter::class)
    fun getTikTokList(@Body requestBody: RequestBody): Observable<BaseBean<MovieBean>>

    /**
     * 获取tikTok-发现
     */
    @POST(HostUrl.Companion.POST_MOVIE_TIK_TOK_FIND)
    @ResponseProcess(MovieResponseConverter::class)
    fun getTikTokFindList(@Body requestBody: RequestBody): Observable<BaseBean<MainTagBean>>

    /**
     * 获取tikTok-分类
     */
    @POST(HostUrl.Companion.POST_MOVIE_TIK_TOK_CLASSIFY)
    @ResponseProcess(MovieResponseConverter::class)
    fun getTikTokClassifyList(@Body requestBody: RequestBody): Observable<BaseBean<ClassifyBean>>

    /**
     * 获取标签内容
     */
    @POST(HostUrl.Companion.POST_MOVIE_LIST_BY_TAG)
    @ResponseProcess(MovieResponseConverter::class)
    fun getMovieListByTag(@Body requestBody: RequestBody): Observable<BaseBean<MainTagBean>>

    /**
     * 主页分类电影接口
     */
    @POST(HostUrl.Companion.POST_MOVIE_LIST_TAG)
    @ResponseProcess(MovieResponseConverter::class)
    fun getMovieTagList(@Body requestBody: RequestBody): Observable<BaseBean<ArrayList<MainMovieBean>>>

    /**


     * 主页分类电影接口
     */
    @POST(HostUrl.Companion.POST_MOVIE_LIST_TAG_NEW)
    @ResponseProcess(MovieResponseConverter::class)
    fun getNewMovieTagList(@Body requestBody: RequestBody): Observable<BaseBean<ArrayList<MainMovieBean>>>

    /**
     * 主页分类电影接口-子条目分页
     */
    @POST(HostUrl.Companion.POST_MOVIE_LIST_TAG_NEW_MORE)
    @ResponseProcess(MovieResponseConverter::class)
    fun getNewMovieTagListMore(@Body requestBody: RequestBody): Observable<BaseBean<ArrayList<MainMovieBean>>>

    /**
     * 主页分类电影接口
     */
    @POST(HostUrl.Companion.POST_MOVIE_LIST_REFRESH)
    @ResponseProcess(MovieResponseConverter::class)
    fun getRefreshData(@Body requestBody: RequestBody): Observable<BaseBean<RecommendRefreshBean>>

    /**
     * 收藏列表
     */
    @POST(HostUrl.Companion.POST_COLLECTION_LIST)
    fun getCollectionList(@Body requestBody: RequestBody): Observable<BaseBean<MovieBean>>

    /**
     * 收藏列表
     */
    @POST(HostUrl.Companion.POS_MOVIE_STAR)
    fun getAllStar(): Observable<BaseBean<AllStarBean>>

    /**
     * 金币购买影片列表
     */
    @POST(HostUrl.Companion.POST_BUY_LIST)
    fun getBuyList(@Body requestBody: RequestBody): Observable<BaseBean<BuyCoinBean>>

    /**
     * 分享
     */
    @POST(HostUrl.Companion.POST_SHARE_MOVIE)
    fun shareMovie(@Body requestBody: RequestBody): Observable<BaseBean<String>>

    /**
     * 签到
     */
    @POST(HostUrl.Companion.POST_SIGN_IN)
    fun signIn(@Body requestBody: RequestBody): Observable<BaseBean<String>>

    /**
     * 推广分享
     */
    @POST(HostUrl.Companion.POST_EXCHANGE_SHARE)
    fun exchangeShare(@Body requestBody: RequestBody): Observable<BaseBean<Boolean>>

    /**
     * 提现总金额
     */
    @POST(HostUrl.Companion.POST_CHECK_WITHDRAW)
    fun checkWithdraw(@Body requestBody: RequestBody): Observable<BaseBean<WithdrawBean>>

    /**
     * 提现
     */
    @POST(HostUrl.Companion.POST_WITHDRAW)
    fun withdraw(@Body requestBody: RequestBody): Observable<BaseBean<WithdrawInfoBean>>

    /**
     * 提现记录
     */
    @POST(HostUrl.Companion.POST_WITHDRAW_LIST)
    fun withdrawList(@Body requestBody: RequestBody): Observable<BaseBean<List<WithdrawListBean>>>

    /**
     * 分享码
     */
    @POST(HostUrl.Companion.POST_EXCHANGE_CODE)
    fun exchangeCode(@Body requestBody: RequestBody): Observable<BaseBean<Boolean>>

    /**
     * 分享人数
     */
    @POST(HostUrl.Companion.POST_USER_PROMOTE)
    fun getShareCount(@Body requestBody: RequestBody): Observable<BaseBean<Int>>

    /**
     * 下载接口
     */
    @POST(HostUrl.Companion.POST_DOWNLOAD_MOVIE)
    fun downloadMovie(@Body requestBody: RequestBody): Observable<BaseBean<String>>

    /**
     * 付款-vip
     */
    @POST(HostUrl.Companion.POST_PAY_SUBMIT)
    fun payVip(@Body requestBody: RequestBody): Observable<BaseBean<String>>

    /**
     * 付款-新
     */
    @POST(HostUrl.Companion.POST_PAY_SUBMIT_NEW)
    fun pay(@Body requestBody: RequestBody): Observable<BaseBean<PayCommonTypeBean>>

    /**
     * 付款-金币
     */
    @POST(HostUrl.Companion.POST_PAY_COIN)
    fun payCoin(@Body requestBody: RequestBody): Observable<BaseBean<String>>

    /**
     * 搜索
     */
    @POST(HostUrl.Companion.POST_SEARCH)
    @ResponseProcess(MovieResponseConverter::class)
    fun searchMovie(@Body requestBody: RequestBody): Observable<BaseBean<MainTagBean>>


    /**
     * 搜索
     */
    @POST(HostUrl.Companion.POST_MAIN_SEARCH)
    fun mainSearch(@Body requestBody: RequestBody): Observable<BaseBean<LiveBean>>

    /**
     * 搜索
     */
    @POST(HostUrl.Companion.POST_SPECIALIST_SEARCH)
    fun specialistSearch(@Body requestBody: RequestBody): Observable<BaseBean<SpecialBallBean>>

    /**
     * 点赞
     */
    @POST(HostUrl.Companion.POST_MOVIE_LIKE)
    fun likeMovie(@Body requestBody: RequestBody): Observable<BaseBean<LikeBean>>

    /**
     * 收藏
     */
    @POST(HostUrl.Companion.POST_MOVIE_COLLECTION)
    fun collectMovie(@Body requestBody: RequestBody): Observable<BaseBean<LikeBean>>

    /**
     * 播放
     */
    @POST(HostUrl.Companion.POST_PLAY_MOVIE)
    fun playMovie(@Body requestBody: RequestBody): Observable<BaseBean<PlayMovieBean>>

    /**
     * 获取活动
     */
    @POST(HostUrl.Companion.POST_PROMOTION)
    fun getPromotion(): Observable<BaseBean<List<PromotionBean>>>

    /**
     * 获取活动
     */
    @POST(HostUrl.Companion.POST_PROMOTION_LIST)
    fun getPromotionList(@Body requestBody: RequestBody): Observable<BaseBean<List<PromotionListBean>>>


    /**
     * 获取女优列表
     */
    @POST(HostUrl.Companion.POST_MOVIE_STAR_LIST)
    fun getMovieStarList(@Body requestBody: RequestBody): Observable<BaseBean<StarBean>>

    /**
     * 获取女优列表
     */
    @POST(HostUrl.Companion.POST_MOVIE_STAR_DETAIL)
    fun getMovieStarDetail(@Body requestBody: RequestBody): Observable<BaseBean<StarDetailBean>>

    /**
     * 获取房间信息
     */
    @POST(HostUrl.Companion.POST_ROOM_INFO)
    fun getRoomInfo(@Body requestBody: RequestBody): Observable<BaseBean<RoomInfoEntity>>

    /**
     * 获取机器人聊天信息
     */
    @POST(HostUrl.Companion.POST_ROOM_FAKE_MESSAGE)
    fun getFakeMessage(): Observable<BaseBean<FakeMessageEntity>>

    /**
     * 获取文字直播
     */
    @POST(HostUrl.Companion.POST_MATCH_LIVE)
    fun getMatchLive(@Body requestBody: RequestBody): Observable<BaseBean<TextLiveBean?>>

    /**
     * 获取红榜相关
     */
    @POST(HostUrl.Companion.POST_RED_ASSOCIATE)
    fun getRedAssociate(@Body requestBody: RequestBody): Observable<BaseBean<RedListEntity?>>

    /**
     * 关注专家
     */
    @POST(HostUrl.Companion.POST_FOCUS_EXPERT)
    fun focusExpert(@Body requestBody: RequestBody): Observable<BaseBean<Any?>>

    /**
     * 取消关注专家
     */
    @POST(HostUrl.Companion.POST_CANCEL_FOCUS_EXPERT)
    fun cancelFocusExpert(@Body requestBody: RequestBody): Observable<BaseBean<Any?>>

    /**
     * 获取红榜详情
     */
    @POST(HostUrl.Companion.POST_RED_DETAIL)
    fun getRedDetail(@Body requestBody: RequestBody): Observable<BaseBean<RedDetailEntity?>>

    /**
     * 获取专家详情
     */
    @POST(HostUrl.Companion.POST_SPECIALIST_DETAIL)
    fun getSpecialistDetail(@Body requestBody: RequestBody): Observable<BaseBean<SpecialistDetailEntity?>>


    /**
     * 获取红榜列表
     */
    @POST(HostUrl.Companion.POST_RED_RANK_LIST)
    fun getRedList(@Body requestBody: RequestBody): Observable<BaseBean<RedListEntity?>>


    /**
     * 获取篮球详情
     */
    @POST(HostUrl.Companion.POST_MATCH_INFO_BASKETBALL)
    fun getBasketballInfo(@Body requestBody: RequestBody): Observable<BaseBean<MatchBasketballEntity?>>


    /**
     * 获取足球详情
     */
    @POST(HostUrl.Companion.POST_MATCH_INFO_FOOTBALL)
    fun getFootBallInfo(@Body requestBody: RequestBody): Observable<BaseBean<MatchFootballBeanKt?>>

    /**
     * 获取足球详情
     */
    @POST(HostUrl.Companion.POST_MATCH_LIVE_LIST)
    fun getMatchLiveList(@Body requestBody: RequestBody): Observable<BaseBean<MutableList<MatchLiveBean?>?>>

    /**
     * 获取礼物列表
     */
    @POST(HostUrl.Companion.POST_ROOM_GIFT_LIST)
    fun getGiftList(): Observable<BaseBean<List<GiftBean>>>


    /**
     * 赠送礼物
     */
    @POST(HostUrl.Companion.POST_ROOM_SEND_LIST)
    fun sendGift(@Body requestBody: RequestBody): Observable<BaseBean<String>>

    /**
     * 历史消息
     */
    @POST(HostUrl.Companion.POST_GET_CHAT_HISTORY_MESSAGE)
    fun getHistoryMessage(@Body requestBody: RequestBody): Observable<BaseBean<List<HistoryMessageEntity>>>

    /**
     * 获取赛事列表
     */
    @POST(HostUrl.Companion.POST_ROOM_RANK)
    fun getRankList(@Body requestBody: RequestBody): Observable<BaseBean<List<LiveRankBean>>>

    /**
     * 获取主播详情
     */
    @POST(HostUrl.Companion.POST_ROOM_ANCHOR_MATCH)
    fun getAnchorMatch(@Body requestBody: RequestBody): Observable<BaseBean<MatchContentBean>>


    /**
     * 修改用户信息
     */
    @POST(HostUrl.POST_EDIT_USER)
    fun editUser(@Body requestBody: RequestBody): Observable<BaseBean<String>>


    /**
     * 获取公告接口
     */
    @POST(HostUrl.POST_COMMON_MESSAGE_LIST)
    fun getMessageList(@Body requestBody: RequestBody): Observable<BaseBean<MessageBean>>


    /**
     * 获取分享文案
     */
    @POST(HostUrl.POST_COMMON_GET_SHARE_CONFIG)
    fun getShareConfig(): Observable<BaseBean<ShareBean>>

    /**
     * 获取新闻tag
     */
    @GET(HostUrl.POST_NEWS_TAG_LIST)
    fun getNewsTagList(): Observable<BaseBean<List<NewsTagItemEntity>>>

    /**
     * 获取新闻List
     */
    @POST(HostUrl.POST_NEWS_LIST)
    fun getNewsList(@Body requestBody: RequestBody): Observable<BaseBean<NewsDataBean>>

    /**
     * 获取新闻详情
     */
    @POST(HostUrl.POST_NEWS_DETAIL)
    fun getNewsDetail(@Body requestBody: RequestBody): Observable<BaseBean<NewDetailEntity>>

    /**
     * 获取篮球指数
     */
    @POST(HostUrl.POST_MATCH_BASKETBALL_ODDS)
    fun getBasketballOdds(@Body requestBody: RequestBody): Observable<BaseBean<MatchOddBasketEntity>>

    /**
     * 获取足球指数
     */
    @POST(HostUrl.POST_MATCH_FOOTBALL_ODDS)
    fun getFootBallOdds(@Body requestBody: RequestBody): Observable<BaseBean<MatchOddEntity>>

    /**
     * 给新闻点赞
     */
    @POST(HostUrl.POST_CLICK_NEWS)
    fun clickNews(@Body requestBody: RequestBody): Observable<BaseBean<String>>

    /**
     * 获取新闻头部List
     */
    @POST(HostUrl.POST_LIVE_BANNER)
    fun getNewsHeadList(@Body requestBody: RequestBody): Observable<BaseBean<List<BannerBean>>>

    /**
     * 退出登录
     */
    @POST(HostUrl.POST_LOGIN_OUT)
    fun loginOut(): Observable<BaseBean<String>>


    /**
     * 注销账号
     */
    @POST(HostUrl.POST_DESTROY_USER)
    fun destroyUser(): Observable<BaseBean<String>>

    /**
     * 注销账号
     */
    @POST(HostUrl.POST_CHECK_VERSION)
    fun checkVersion(@Body requestBody: RequestBody): Observable<BaseBean<UpdateEntity>>

    /**
     * 修改手机号码
     */
    @POST(HostUrl.POST_UPDATE_PHONE)
    fun verifyCode(@Body requestBody: RequestBody): Observable<BaseBean<String>>


    /**
     * 修改手机号码-第二步
     */
    @POST(HostUrl.POST_UPDATE_PHONE_BIND_NEW)
    fun bindNewPhone(@Body requestBody: RequestBody): Observable<BaseBean<String>>

    /**
     * 修改用户信息
     */
    @POST(HostUrl.POST_USER_INFO_BY_IDS)
    fun getUserInfoByIds(@Body requestBody: RequestBody): Observable<BaseBean<List<LiveUserBean>>>

    /**
     * 上传
     * Multipart 这个注解代表多表单上传
     * @param partList 表单信息
     * @return .
     */
    @Multipart
    @POST(HostUrl.POST_FILE)
    fun uploadFile(@Part image: MultipartBody.Part): Observable<BaseBean<String>>


    /**
     * 修改用户信息
     */
    @POST(HostUrl.POST_EDIT_USER_AVATAR)
    fun editUserAvatar(@Body requestBody: RequestBody): Observable<BaseBean<String>>


    /**
     * 获取用户信息接口
     */
    @POST(HostUrl.POST_USER_INFO)
    fun getUserInfo(): Observable<BaseBean<LiveUserBean>>

}