package com.hupu.tv.player.app.app


import android.content.Intent
import android.content.pm.PackageManager
import android.content.res.Configuration
import android.widget.ImageView
import androidx.appcompat.app.AppCompatActivity
import androidx.multidex.MultiDex
import com.blankj.utilcode.util.AppUtils
import com.blankj.utilcode.util.LogUtils
import com.hupu.tv.player.app.BuildConfig
import com.hyphenate.chat.EMClient
import com.hyphenate.chat.EMOptions
import com.hyphenate.easeui.EaseIM
import com.hyphenate.easeui.delegate.*
import com.hyphenate.easeui.manager.EaseMessageTypeSetManager
import com.kongzue.dialog.util.DialogSettings
import com.shuyu.gsyvideoplayer.GSYVideoManager
import com.shuyu.gsyvideoplayer.cache.CacheFactory
import com.shuyu.gsyvideoplayer.model.VideoOptionModel
import com.shuyu.gsyvideoplayer.player.PlayerFactory
import com.shuyu.gsyvideoplayer.utils.Debuger
import com.softgarden.baselibrary.BaseApplication
import com.softgarden.baselibrary.utils.ActivityManager
import com.softgarden.baselibrary.utils.SPUtil
import com.softgarden.baselibrary.utils.ScreenUtil
import com.umeng.analytics.MobclickAgent
import com.umeng.commonsdk.UMConfigure
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.ui.activity.SplashActivity
import com.hupu.tv.player.app.ui.im.ChatPresenter
import com.hupu.tv.player.app.ui.im.EaseChatRowDelegate
import com.hupu.tv.player.app.utils.CommonUtils
import com.hupu.tv.player.app.utils.CrashHandler
import com.hupu.tv.player.app.utils.DialogUtils
import com.hupu.tv.player.app.utils.OKHttpUpdateHttpService
import com.xuexiang.xupdate.XUpdate
import com.xuexiang.xupdate.entity.UpdateError.ERROR.CHECK_NO_NEW_VERSION
import com.yhao.floatwindow.FloatWindow
import com.yhao.floatwindow.MoveType
import com.yhao.floatwindow.Screen
import tv.danmaku.ijk.media.exo2.Exo2PlayerManager
import tv.danmaku.ijk.media.exo2.ExoPlayerCacheManager
import tv.danmaku.ijk.media.player.IjkMediaPlayer
import java.util.logging.Handler


/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe
 */
class App : BaseApplication() {
    private var oldOrientation = Configuration.ORIENTATION_PORTRAIT

    companion object {
        var instance: App? = null
            private set
    }

    /**
     * 使用EMAIL发送日志
     */
//    private fun initEmailReporter() {
//        val reporter = CrashEmailReporter(this)
//        reporter.setReceiver("ilovexy2tom@163.com")
//        reporter.setSender("ilovexy2tom@163.com")
//        reporter.setSendPassword("FAUBJWXLBTEEQIGX")
//        reporter.setSMTPHost("smtp.163.com")
//        reporter.setPort("465")
//        AndroidCrash.getInstance().setCrashReporter(reporter).init(this)
//    }
//    private fun initCrashHandler(){
//        val log: Logger = Logger.getLogger(App::class.java)
//        val crashHandler = CrashHandler.getInstance()
//        crashHandler.init(this)
//        object : Thread() {
//            override fun run() {
//                Log4jConfigure.configure(filesDir.absolutePath)
//                log.info("configure log4j ok")
//            }
//        }.start()
//    }

    override fun onCreate() {
        super.onCreate()
        oldOrientation = resources.configuration.orientation
        instance = this
        UMConfigure.preInit(instance, null, null)
        initCustomDialog()
        val isAgree = SPUtil[Constants.IS_AGREE, false] as Boolean
        if (isAgree) {
            initLib()
        }

//        initM3U8Downloader()
//        initEmailReporter()
//        initCrashHandler()
//        crashHandler.init(this)
//        initFloat()


    }

    fun initLib() {
        MultiDex.install(this)
        initUpdate()
        initCrash()
        initGsyPlayer()
        initIM()
        initUmeng()
    }

    override fun onConfigurationChanged(newConfig: Configuration) {
        super.onConfigurationChanged(newConfig)
        LogUtils.e("onConfigurationChanged newConfig = $newConfig")
        if (newConfig.orientation != oldOrientation) {
            oldOrientation = newConfig.orientation
        }else{
            //更改了系统设置 ，比如 更改字体大小 设置语言等
            ActivityManager.instance.finishAll()
            val intent = Intent(this, SplashActivity::class.java)
            intent.addFlags(
                Intent.FLAG_ACTIVITY_NEW_TASK
                        or Intent.FLAG_ACTIVITY_CLEAR_TOP or Intent.FLAG_ACTIVITY_CLEAR_TASK
            )
            startActivity(intent)
            LogUtils.e("onConfigurationChanged relaunchApp")

        }
    }

    private fun initUmeng() {

        val umChanelId = packageManager.getApplicationInfo(
            packageName,
            PackageManager.GET_META_DATA
        ).metaData.getString("UMENG_CHANNEL_VALUE")


        UMConfigure.init(
            instance,
            UMConfigure.DEVICE_TYPE_PHONE,
            ""
        )
        UMConfigure.setLogEnabled(BuildConfig.DEBUG)

        //选择AUTO页面采集模式，统计SDK基础指标无需手动埋点可自动采集。
        //建议在宿主App的Application.onCreate函数中调用此函数。
        MobclickAgent.setPageCollectionMode(MobclickAgent.PageMode.LEGACY_MANUAL);
    }

    private fun initM3U8Downloader() {
        //开启日志
        //检查 Renderscript 兼容性，若设备不支持，DialogSettings.isUseBlur 会自动关闭；

        //        M3U8DownloaderConfig
        //                .build(applicationContext)
        //                .setSaveDir(filesDir.path)
        //                .setConnTimeout(10000)
        //                .setReadTimeout(10000)
        //                .setThreadCount(3)
        //                .setDebugMode(true)
        //        Debuger.enable()
    }

    private fun initCrash() {
        val crashHandler = CrashHandler.getInstance()
        crashHandler.init(instance)
    }

    private fun initGsyPlayer() {
        //GSYVideoType.enableMediaCodec();
        //GSYVideoType.enableMediaCodecTexture();
        if (BuildConfig.DEBUG) {
            Debuger.enable()
        } else {
            Debuger.disable()
        }

        PlayerFactory.setPlayManager(Exo2PlayerManager::class.java)//EXO模式

        //ExoSourceManager.setSkipSSLChain(true);


        //        PlayerFactory.setPlayManager(SystemPlayerManager::class.java);//系统模式
        //        PlayerFactory.setPlayManager(IjkPlayerManager::class.java)//ijk模式
        //
        CacheFactory.setCacheManager(ExoPlayerCacheManager::class.java);//exo缓存模式，支持m3u8，只支持exo
        //CacheFactory.setCacheManager(ProxyCacheManager.class);//代理缓存模式，支持所有模式，不支持m3u8等

        //GSYVideoType.setShowType(GSYVideoType.SCREEN_MATCH_FULL);
        //GSYVideoType.setShowType(GSYVideoType.SCREEN_TYPE_FULL);
        //GSYVideoType.setShowType(GSYVideoType.SCREEN_MATCH_FULL);

        //GSYVideoType.setShowType(GSYVideoType.SCREEN_TYPE_CUSTOM);
        //GSYVideoType.setScreenScaleRatio(9.0f/16);

        //GSYVideoType.setRenderType(GSYVideoType.SUFRACE);
        //        GSYVideoType.setRenderType(GSYVideoType.GLSURFACE);
        //        IjkPlayerManager.setLogLevel(IjkMediaPlayer.IJK_LOG_ERROR)

        val videoOptionModel = VideoOptionModel(
            IjkMediaPlayer.OPT_CATEGORY_FORMAT,
            "protocol_whitelist",
            "crypto, file, http, https, tcp, tls, udp"
        )
        val list: MutableList<VideoOptionModel> = ArrayList()
        list.add(videoOptionModel)
        GSYVideoManager.instance().optionModelList = list
    }

    private fun initIM() {

        val options = EMOptions()
        // 默认添加好友时，是不需要验证的，改成需要验证
        options.acceptInvitationAlways = false
        // 是否自动将消息附件上传到环信服务器，默认为True是使用环信服务器上传下载，如果设为 false，需要开发者自己处理附件消息的上传和下载
        options.autoTransferMessageAttachments = true
        // 是否自动下载附件类消息的缩略图等，默认为 true 这里和上边这个参数相关联
        options.setAutoDownloadThumbnail(true)
        //初始化
        EaseIM.getInstance().init(this, options)
        registerConversationType()
        //在做打包混淆时，关闭debug模式，避免消耗不必要的资源

        //添加ChatPresenter,ChatPresenter中添加了网络连接状态监听，
        EaseIM.getInstance().addChatPresenter(ChatPresenter.getInstance())
        EMClient.getInstance().setDebugMode(BuildConfig.DEBUG)
    }


    /**
     * 注册对话类型
     */
    private fun registerConversationType() {
        EaseMessageTypeSetManager.getInstance()
            .addMessageType(EaseExpressionAdapterDelegate::class.java) //自定义表情
            .addMessageType(EaseFileAdapterDelegate::class.java) //文件
            .addMessageType(EaseImageAdapterDelegate::class.java) //图片
            .addMessageType(EaseLocationAdapterDelegate::class.java) //定位
            .addMessageType(EaseVideoAdapterDelegate::class.java) //视频
            .addMessageType(EaseVoiceAdapterDelegate::class.java) //声音
            .addMessageType(EaseCustomAdapterDelegate::class.java) //自定义消息
            .setDefaultMessageType(EaseChatRowDelegate::class.java) //文本
    }

    private fun initFloat() {
        val imageView = ImageView(applicationContext)
        imageView.setImageResource(R.mipmap.icon_float_button)
        FloatWindow.with(applicationContext)
            .setView(imageView)
            .setHeight(200)
            .setHeight(200)
            .setMoveType(MoveType.active)
            .setX(Screen.width, 0.7f)                                   //设置控件初始位置
//                .setY(Screen.height, 0.5f)
            .setY(((ScreenUtil.getScreenHeight(this) - ScreenUtil.getNegativeHeight(this)) * 0.8).toInt())
            .setDesktopShow(false) //桌面显示
            .build()
        imageView.setOnClickListener {
            if (SPUtil[Constants.WELL_PALY_TYPE, ""] as String == Constants.PLAY_TYPE) {
                ActivityManager.instance.getCurrent<AppCompatActivity>()
                    ?.startActivity(CommonUtils.toWeb(SPUtil[Constants.CUSTOMER_LINK, ""] as String))
            } else {
                DialogUtils.showFloatButton(
                    ActivityManager.instance.getCurrent(),
                    object : DialogUtils.OnClickSingleListener {
                        override fun onClick() {
                            CommonUtils.copy(SPUtil[Constants.CONTRACT, ""] as String)
                            if (SPUtil[Constants.CONTRACT_TYPE, ""] as String == Constants.CONTRACT_QQ) {
                                ActivityManager.instance.getCurrent<AppCompatActivity>()
                                    ?.startActivity(CommonUtils.toQQ())
                            } else {
                                ActivityManager.instance.getCurrent<AppCompatActivity>()
                                    ?.startActivity(CommonUtils.toWeChat())
                            }
                        }
                    })
            }
        }
    }


    private fun initUpdate() {
        XUpdate.get()
            .debug(BuildConfig.DEBUG)
            .isWifiOnly(false) //默认设置只在wifi下检查版本更新
            .isGet(false) //默认设置使用get请求检查版本
            .isAutoMode(false) //默认设置非自动模式，可根据具体使用配置
//                .param("channel", BuildConfig.CHANNEL_ID) //设置默认公共请求参数
//                .param("ctype", 1)
            .setOnUpdateFailureListener { error ->
                //设置版本更新出错的监听
                if (error.code != CHECK_NO_NEW_VERSION) {          //对不同错误进行处理
                    //                        ToastUtil.s(error.toString())
                }
            }
            .supportSilentInstall(false) //设置是否支持静默安装，默认是true
            .setIUpdateHttpService(OKHttpUpdateHttpService()) //这个必须设置！实现网络请求功能。
            .init(this)
    }

    private fun initCustomDialog() {
        DialogSettings.isUseBlur = false
        DialogSettings.backgroundColor = R.color.transparent
        DialogSettings.modalDialog = false
        DialogSettings.init()
    }
}