package com.hupu.tv.player.app.base

import android.content.Intent
import android.graphics.Color
import android.os.Bundle

import android.view.View
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.TextView
import androidx.annotation.ColorRes
import androidx.appcompat.app.AppCompatActivity
import androidx.core.content.ContextCompat
import androidx.recyclerview.widget.OrientationHelper
import androidx.recyclerview.widget.RecyclerView
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.BaseQuickAdapter.RequestLoadMoreListener
import com.scwang.smartrefresh.layout.SmartRefreshLayout
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.network.ApiException
import com.softgarden.baselibrary.utils.DisplayUtil
import com.softgarden.baselibrary.utils.EmptyUtil
import com.softgarden.baselibrary.widget.ColorDividerDecoration
import com.softgarden.baselibrary.widget.GridDividerDecoration
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.ui.activity.LoginActivity
import com.hupu.tv.player.app.utils.EmptyConfig
import com.hupu.tv.player.app.utils.GlideUtils
import com.hupu.tv.player.app.utils.UserHelper
import com.softgarden.baselibrary.utils.ScreenUtil
import me.bakumon.statuslayoutmanager.library.OnStatusChildClickListener
import me.bakumon.statuslayoutmanager.library.StatusLayoutManager

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe 通用的列表刷新Activity
 *
 *
 * 上拉刷新用的是 SmartRefreshLayout
 * 下拉加载用的是 BaseAdapter带的
 * 注意事项：
 * 刷新控件 id必须为：mRefreshLayout
 * RecyclerView id必须为：mRecyclerView
 * 当然也可以自己调整
 */
abstract class RefreshActivity<P : IBasePresenter?> : ToolbarActivity<P>(),
    RequestLoadMoreListener {
    /*** 每页请求数量  */
    var PAGE_COUNT = 10
    protected lateinit var mStatusLayoutManager: StatusLayoutManager

    /*** 页码，默认从1开始  */
    protected var PageStart = 1
    protected var mPage = 1

    /*** 空布局类型 可以在这里设置默认值  */
    protected var emptyType = -1

    /*** 是否启用空布局  */
    private var enableEmptyView = true
    protected var isRefresh = false
    protected var isLoadEnd = false //是否已经加载完了，没有更多数据了 = false
    protected var mRefreshLayout: SmartRefreshLayout? = null
    protected var mRecyclerView: RecyclerView? = null
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        loadData()
    }

    /**
     * 设置刷新框架，需要时调用即可
     */
    protected fun initRefreshLayout() {
        mRefreshLayout = findViewById(R.id.mRefreshLayout)
//        val customClassicsHeader = CustomClassicsHeader(this)
        mRefreshLayout?.let {
            it.isEnabled = true
            it.setEnableLoadMore(false)
            it.setEnableRefresh(true)
            it.setDisableContentWhenLoading(true)
            it.setDisableContentWhenRefresh(true)
//            it.setRefreshHeader(customClassicsHeader)
            it.setOnRefreshListener { onRefresh() }
        }
//        customClassicsHeader.setDrawableSize(10f)
    }

    /**
     * 开关刷新
     *
     * @param enableRefresh
     */
    fun setEnableRefresh(enableRefresh: Boolean) {
        mRefreshLayout?.setEnableRefresh(enableRefresh)
    }

    /**
     * 初始化列表控件
     */
    protected fun initRecyclerView() {
        mRecyclerView = findViewById<View>(R.id.mRecyclerView) as RecyclerView
    }

    fun setPageCount(pageCount: Int) {
        PAGE_COUNT = pageCount
    }


    /**
     * 设置分割线
     *
     * @param id
     */
    protected fun addItemDecoration(@ColorRes id: Int) {
        if (mRecyclerView != null) {
            mRecyclerView?.addItemDecoration(
                ColorDividerDecoration(
                    ContextCompat.getColor(
                        activity,
                        id
                    )
                )
            )
        }
    }

    protected fun addItemDecoration(@ColorRes id: Int, dp: Int) {
        if (mRecyclerView != null) {
            mRecyclerView?.addItemDecoration(
                ColorDividerDecoration(
                    ContextCompat.getColor(
                        this,
                        id
                    ), DisplayUtil.dip2px(activity, dp.toFloat())
                )
            )
        }
    }

    protected fun addItemDecoration(
        recyclerView: RecyclerView?,
        @ColorRes id: Int,
        dp: Int,
        mOrientation: Int = OrientationHelper.VERTICAL
    ) {
        recyclerView?.let {
            it.addItemDecoration(
                ColorDividerDecoration(
                    mOrientation,
                    ContextCompat.getColor(activity, id),
                    DisplayUtil.dip2px(activity, dp.toFloat())
                )
            )
        }

    }

    protected fun addGridItemDecoration(@ColorRes id: Int, dp: Int) {
        if (mRecyclerView != null) {
            mRecyclerView!!.addItemDecoration(
                GridDividerDecoration(
                    DisplayUtil.dip2px(
                        activity,
                        dp.toFloat()
                    ), ContextCompat.getColor(activity, id)
                )
            )
        }
    }

    protected fun addGridItemDecoration(recyclerView: RecyclerView?, @ColorRes id: Int, dp: Int) {
        if (recyclerView != null) {
            recyclerView.addItemDecoration(
                GridDividerDecoration(
                    DisplayUtil.dip2px(
                        activity,
                        dp.toFloat()
                    ), ContextCompat.getColor(activity, id)
                )
            )
        }
    }

    protected fun addItemDecoration() {
        //设置默认分割线
        if (mRecyclerView != null) {
            mRecyclerView!!.addItemDecoration(ColorDividerDecoration(Color.parseColor("#CCCCCC")))
        }
    }

    /**
     * 自动刷新
     */
    fun autoRefresh() {
        if (mRefreshLayout != null) mRefreshLayout!!.autoRefresh(0)
    }

    /**
     * 结束刷新
     */
    fun finishRefresh() {
        if (mRefreshLayout != null) mRefreshLayout!!.finishRefresh(0)
    }

    /***
     * 是否启用空布局
     * @param enableEmptyView
     */
    fun setEnableEmptyView(enableEmptyView: Boolean) {
        this.enableEmptyView = enableEmptyView
    }

    fun setEnableEmptyView(enableEmptyView: Boolean, emptyType: Int) {
        this.enableEmptyView = enableEmptyView
        this.emptyType = emptyType
    }

    fun setLoadData(adapter: BaseQuickAdapter<*, *>, list: List<*>?) {
        setLoadData(adapter, list, emptyType) //emptyType 可以给一个默认值,作为统一设置
    }

    /**
     * 不分页的 设置数据
     *
     * @param adapter
     * @param list
     * @param emptyType
     */
    fun setLoadData(adapter: BaseQuickAdapter<*, *>, list: List<*>?, emptyType: Int) {
        this.emptyType = emptyType
        adapter.setHeaderFooterEmpty(true, true) //是否显示头部和底部
        finishRefresh()
        adapter.setNewData(list as List<Nothing>?)
        if (EmptyUtil.isEmpty(list)) {
            setEmptyView(adapter)
        }
    }

    fun setLoadMore(adapter: BaseQuickAdapter<*, *>, list: List<*>?) {
        setLoadMore(adapter, list, emptyType)
    }

    /**
     * 如果使用的是当前的 mRecyclerView
     *
     * @param adapter
     * @param list
     * @param emptyType
     */
    fun setLoadMore(adapter: BaseQuickAdapter<*, *>, list: List<*>?, emptyType: Int) {
        if (mRecyclerView != null) {
            setLoadMore(mRecyclerView, adapter, list, emptyType)
        }
    }

    /**
     * 结束刷新
     * 自动设置上拉更多
     *
     * @param adapter
     * @param list
     */
    fun setLoadMore(
        recyclerView: RecyclerView?,
        adapter: BaseQuickAdapter<*, *>,
        list: List<*>?,
        emptyType: Int
    ) {
        this.emptyType = emptyType
        adapter.setHeaderFooterEmpty(true, true) //是否显示头部和底部
        finishRefresh() //结束刷新
        if (mPage == PageStart) {
            isLoadEnd = false
            adapter.setNewData(list as List<Nothing>?)
            if (EmptyUtil.isEmpty(list)) {
                isLoadEnd = true
                setEmptyView(adapter)
            }
        } else {
            if (list != null && !list.isEmpty()) {
                adapter.addData(list as List<Nothing>)
            }
        }
        if (list == null || list.size < PAGE_COUNT) {
            isLoadEnd = true
            adapter.loadMoreEnd()
        } else {
            adapter.setEnableLoadMore(true)
            adapter.setOnLoadMoreListener(this, recyclerView)
            adapter.loadMoreComplete()
        }
    }

    /**
     * 设置空状态
     *
     *
     * 根据项目情况 自由定制
     *
     * @param adapter
     */
    protected fun setEmptyView(adapter: BaseQuickAdapter<*, *>?) {
        if (enableEmptyView) {
            val emptyView = View.inflate(activity, R.layout.layout_empty, null) as LinearLayout
            val ivEmpty = emptyView.findViewById<ImageView>(R.id.iv_empty)
            val tvEmpty = emptyView.findViewById<TextView>(R.id.tv_empty)
            val tvEmptyHint = emptyView.findViewById<TextView>(R.id.tv_empty_hint)
            var hintDef = "暂无数据"
            var hintDefDescribe = "暂无数据"
            var imgResId = R.mipmap.place_empty
            when (emptyType) {
                EmptyConfig.NO_HISTORY_DATA -> {
                    hintDef = EmptyConfig.NO_HISTORY_DATA_TEXT
                    hintDefDescribe = EmptyConfig.NO_HISTORY_DATA_TEXT_HINT
                }
                EmptyConfig.NO_DOWNLOAD_DATA -> {
                    hintDef = EmptyConfig.NO_DOWNLOAD_DATA_TEXT
                    hintDefDescribe = EmptyConfig.NO_DOWNLOAD_DATA_TEXT_HINT
                }
                EmptyConfig.NO_COLLECTION -> {
                    hintDef = EmptyConfig.NO_COLLECTION_TEXT
                    hintDefDescribe = EmptyConfig.NO_COLLECTION_TEXT_HINT
                }
                EmptyConfig.NO_WITHDRAW -> {
                    hintDef = EmptyConfig.NO_WITHDRAW_TEXT
                    hintDefDescribe = EmptyConfig.NO_WITHDRAW_TEXT_HINT
                }
                EmptyConfig.NO_BUY -> {
                    hintDef = EmptyConfig.NO_BUY_TEXT
                    hintDefDescribe = EmptyConfig.NO_BUY_TEXT_HINT
                }
                EmptyConfig.NO_FOLLOW_ANCHOR -> {

                    hintDef = EmptyConfig.NO_FOLLOW_ANCHOR_TEXT
                    hintDefDescribe = EmptyConfig.NO_FOLLOW_ANCHOR_HINT
                }

                EmptyConfig.NO_FOLLOW_MATCH -> {

                    hintDef = EmptyConfig.NO_FOLLOW_MATCH_TEXT
                    hintDefDescribe = EmptyConfig.NO_FOLLOW_MATCH_HINT
                }
                EmptyConfig.NO_DETAIL_LIVE -> {

                    hintDef = EmptyConfig.NO_DETAIL_LIVE_TEXT
                    hintDefDescribe = EmptyConfig.NO_DETAIL_LIVE_HINT
                }
                EmptyConfig.NO_DETAIL_RED -> {

                    hintDef = EmptyConfig.NO_DETAIL_RED_TEXT
                    hintDefDescribe = EmptyConfig.NO_DETAIL_RED_HINT
                }
            }
            setEmptyLayoutParams(emptyView)
            ivEmpty.setImageResource(imgResId)
            tvEmpty.text = hintDef
            tvEmptyHint.text = hintDefDescribe
            adapter?.emptyView = emptyView
        }
    }

    private fun setEmptyLayoutParams(emptyView: LinearLayout) {
        emptyView.layoutParams = LinearLayout.LayoutParams(
            LinearLayout.LayoutParams.MATCH_PARENT,
            LinearLayout.LayoutParams.MATCH_PARENT
        )
        val layoutParams = emptyView.layoutParams as LinearLayout.LayoutParams
        //获取不到父布局的padding，默认设置的是18dp(左右），转换为px，所以固定写死
        val paddingStart = mRecyclerView?.paddingStart ?: 0
        val paddingEnd = mRecyclerView?.paddingEnd ?: 0
        layoutParams.width =
            ScreenUtil.getScreenWidth(activity as AppCompatActivity) - paddingStart - paddingEnd
        //                    layoutParams.width = ScreenUtil.getScreenWidth(activity as AppCompatActivity)
        emptyView.requestLayout()
    }


    override fun onApiException(e: ApiException) {
        super.onApiException(e)
        if (e.message == Constants.ERROR_TOKEN) {
            UserHelper.userExitLoginSuccess()
            val intent = Intent(this, LoginActivity::class.java)
            intent.putExtra(Constants.ERROR_TOKEN, true)
            startActivity(intent)
        }
    }

    override fun showCustomException(t: Throwable) {
        super.showCustomException(t)
        if (t.message == "请检查网络") {
            if (this::mStatusLayoutManager.isInitialized) {
                mStatusLayoutManager.showErrorLayout()
            }
        }
    }

    override fun showErrorLayout() {
        super.showErrorLayout()
        if (this::mStatusLayoutManager.isInitialized) {
            mStatusLayoutManager.showErrorLayout()
        }
    }

    fun initStatusLayout(view: View) {
        mStatusLayoutManager = StatusLayoutManager.Builder(view)
            // 设置加载中布局
            .setLoadingLayout(View.inflate(this, R.layout.layout_loading, null).apply {
                GlideUtils.loadImageGif(
                    this,
                    R.mipmap.place_loading,
                    findViewById<ImageView>(R.id.iv_loading)
                )
            })
            // 设置空数据布局
            .setEmptyLayout(com.softgarden.baselibrary.R.layout.layout_status_layout_manager_empty)
            // 设置出错布局
            .setErrorLayout(com.softgarden.baselibrary.R.layout.layout_error)
            // 设置空数据布局重试按钮 ID
            .setEmptyClickViewID(com.softgarden.baselibrary.R.id.bt_status_empty_click)
            // 设置出错布局重试按钮 ID
            .setErrorClickViewID(com.softgarden.baselibrary.R.id.tv_error)
            .setDefaultLayoutsBackgroundColor(getColor(R.color.transparent))
            .setOnStatusChildClickListener(object : OnStatusChildClickListener {
                override fun onEmptyChildClick(view: View?) {

                }

                override fun onErrorChildClick(view: View?) {
                    view?.postDelayed({ loadData() }, 1000)
                    mStatusLayoutManager.showLoadingLayout()

                }

                override fun onCustomerChildClick(view: View?) {

                }
            })
            .build()
    }


    /**
     * 结束刷新
     */
    override fun onRequestFinish() {
        super.onRequestFinish()
        finishRefresh()
    }

    fun onRefresh() {
        mPage = 1
        loadData()
    }

    /**
     * 如需上拉更多 请重写该方法
     */
    override fun onLoadMoreRequested() {
        mPage++
        loadData()
    }

    abstract fun loadData()
}