package com.hupu.tv.player.app.base

import android.graphics.Color

import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import androidx.core.content.ContextCompat
import com.mirkowu.basetoolbar.BaseToolbar
import com.mirkowu.statusbarutil.StatusBarUtil
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.base.IBasePresenter
import com.hupu.tv.player.app.R

abstract class ToolbarActivity<P : IBasePresenter?> : BaseActivity<P>() {
    var baseToolbar: BaseToolbar? = null
        private set

    public override fun bindView() {
        /*** 这里可以对Toolbar进行统一的预设置  */
        var builder = BaseToolbar.Builder(this)
                .setBackButton(R.mipmap.back) //统一设置返回键
//                .setStatusBarColor(Color.RED)//统一设置颜色
                .setBackgroundColor(ContextCompat.getColor(this, R.color.blue))
                .setSubTextColor(Color.WHITE)
                .setTitleTextColor(Color.WHITE)
        builder = setToolbar(builder!!)
        if (builder != null) {
            baseToolbar = builder.build()
            baseToolbar?.hideStatusBar()
        }
        if (baseToolbar != null) {
            //添加Toolbar
            val layout = LinearLayout(this)
            val params = LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT)
            layout.layoutParams = params
            layout.orientation = LinearLayout.VERTICAL
            layout.addView(baseToolbar)
            val mView = activity.layoutInflater.inflate(layoutId, layout, false)
            layout.addView(mView)
            setContentView(layout)

            //将toolbar设置为actionbar
            setSupportActionBar(baseToolbar)
        } else {
            setContentView(layoutId)
        }


        //设置沉浸式透明状态栏
//        StatusBarUtil.setTransparent(this);
//        StatusBarUtil.setStatusBarColor(activity, ContextCompat.getColor(this, R.color.transparent))
//        StatusBarUtil.setStatusBarLightMode(activity)


        //非夜间模式 要开启亮色模式
        // setStatusBarLightMode();
    }

    fun showToolbar() {
        if (baseToolbar != null) baseToolbar!!.visibility = View.VISIBLE
    }

    fun hideToolbar() {
        if (baseToolbar != null) baseToolbar!!.visibility = View.GONE
    }

    /**
     * 不需要toolbar的 可以不用管
     *
     * @return
     */
    protected abstract fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder?
}