package com.hupu.tv.player.app.base

import android.graphics.Color
import android.os.Bundle

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import androidx.core.content.ContextCompat
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.IBasePresenter
import com.hupu.tv.player.app.R

abstract class ToolbarFragment<P : IBasePresenter?> : RefreshFragment<P>() {
    var toolbar: BaseToolbar? = null


    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        var mView = inflater.inflate(layoutId, container, false)
        mView = setSupportToolbar(mView)
        return mView
    }

    private fun setSupportToolbar(mView: View): View {
        /*** 这里可以对Toolbar进行统一的预设置  */
        var builder = BaseToolbar.Builder(context) //                .setBackButton(R.mipmap.back)//统一设置返回键
                .setStatusBarColor(Color.TRANSPARENT) //统一设置颜色
                .setBackgroundColor(ContextCompat.getColor(context!!, R.color.transparent))
                .setSubTextColor(Color.WHITE)
                .setTitleTextColor(Color.WHITE)
        builder = setToolbar(builder!!)
        if (builder != null) {
            toolbar = builder.build()
            toolbar?.hideStatusBar()
        }
        if (toolbar != null) {
            toolbar?.minimumHeight = 54
            //添加Toolbar
            val layout = LinearLayout(context)
            val params = LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT)
            layout.layoutParams = params
            layout.orientation = LinearLayout.VERTICAL
            layout.addView(toolbar)
            layout.addView(mView)
            return layout
        }
        return mView
    }

    fun showToolbar() {
        if (toolbar != null) toolbar!!.visibility = View.VISIBLE
    }

    fun hideToolbar() {
        if (toolbar != null) toolbar!!.visibility = View.GONE
    }

    /**
     * 不需要toolbar的 可以不用管
     *
     * @return
     */
    protected abstract fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder?
}