package com.hupu.tv.player.app.bean;

import android.text.TextUtils;

import com.hupu.tv.player.app.app.Constants;

import java.io.Serializable;
import java.util.ArrayList;

/**
 * @author by Dell
 * @date on 2020/6/22
 * @describe
 */
public class AdBean implements Serializable {


    /**
     * id : 2
     * adTitle : 首页滚动1
     * adDes : 首页滚动1
     * adUrl : https://image.mn52.com/img/allimg/190917/8-1Z91G04321.jpg
     * picPath :
     * adType : 2
     * deleted : 1
     */

    private int id;
    private String adTitle;
    private String adDes;
    private String adUrl;
    private String picPath;
    private String picFullPath;
    private String adType;
    private int deleted;

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getPicFullPath() {
        return picFullPath;
    }

    public void setPicFullPath(String picFullPath) {
        this.picFullPath = picFullPath;
    }

    public String getAdTitle() {
        return adTitle;
    }

    public void setAdTitle(String adTitle) {
        this.adTitle = adTitle;
    }

    public String getAdDes() {
        return adDes;
    }

    public void setAdDes(String adDes) {
        this.adDes = adDes;
    }

    public String getAdUrl() {
        return adUrl;
    }

    public void setAdUrl(String adUrl) {
        this.adUrl = adUrl;
    }

    public String getPicPath() {
        return picPath;
    }

    public void setPicPath(String picPath) {
        this.picPath = picPath;
    }

    public String getAdType() {
        return adType;
    }

    public void setAdType(String adType) {
        this.adType = adType;
    }

    public int getDeleted() {
        return deleted;
    }

    public void setDeleted(int deleted) {
        this.deleted = deleted;
    }

    /**
     * 获取splash页广告
     */
    public static ArrayList<AdBean> getSplashAd(ArrayList<AdBean> list) {
        ArrayList<AdBean> beans = new ArrayList<>();
        for (AdBean adBean : list) {
            if (TextUtils.equals(adBean.adType, Constants.SPLASH_AD_TYPE)) {
                beans.add(adBean);
            }
        }
        return beans;
    }

    /**
     * 获取首页banner
     */
    public static ArrayList<AdBean> getMainAd(ArrayList<AdBean> list) {
        ArrayList<AdBean> beans = new ArrayList<>();
        for (AdBean adBean : list) {
            if (TextUtils.equals(adBean.adType, Constants.MAIN_AD_TYPE)) {
                beans.add(adBean);
            }
        }
        return dealData(beans);
    }

    /**
     * 获取支付广告
     */
    public static ArrayList<AdBean> getPayAd(ArrayList<AdBean> list) {
        ArrayList<AdBean> beans = new ArrayList<>();
        for (AdBean adBean : list) {
            if (TextUtils.equals(adBean.adType, Constants.PAY_AD_TYPE)) {
                beans.add(adBean);
            }
        }
        return beans;
    }

    /**
     * 获取电影广告
     */
    public static AdBean getMovieAd(ArrayList<AdBean> list) {
        for (AdBean adBean : list) {
            if (TextUtils.equals(adBean.adType, Constants.MOVIE_AD_TYPE)) {
                return adBean;
            }
        }
        return null;
    }

    /**
     * 获取电影底部
     */
    public static ArrayList<AdBean> getMovieAdDetail(ArrayList<AdBean> list) {
        ArrayList<AdBean> beans = new ArrayList<>();
        for (AdBean adBean : list) {
            if (TextUtils.equals(adBean.adType, Constants.MOVIE_DETIAL_AD_TYPE)) {
                beans.add(adBean);
            }
        }
        return beans;
    }

    /**
     * 获取分销图片
     */
    public static AdBean getAgentAd(ArrayList<AdBean> list) {
        for (AdBean adBean : list) {
            if (TextUtils.equals(adBean.adType, Constants.AGENT_AD_TYPE)) {
                return adBean;
            }
        }
        return null;
    }

    /**
     * 为了让Viewpager轮播的时候不要出现闪屏的问题
     * 需要在真实数据的两边添加占位数据
     * 而Fragment会偶尔出现占位数据的问题
     * 所以要把占位数据设置成边界数据
     *
     * @param adBeanList
     */
    public static ArrayList<AdBean> dealData(ArrayList<AdBean> adBeanList) {
        //初始边距占位数据 图片要和最后一张一样，其他数据和第一张一样
        if (adBeanList.size() == 0) {
            return adBeanList;
        }
        AdBean startBean = new AdBean();
        startBean.setPicFullPath(adBeanList.get(adBeanList.size() - 1).picFullPath);
        startBean.setAdUrl(adBeanList.get(0).getAdUrl());
        startBean.setAdTitle(adBeanList.get(0).getAdTitle());
        startBean.setAdType(adBeanList.get(0).getAdType());
        startBean.setAdDes(adBeanList.get(0).getAdDes());
        startBean.setId(adBeanList.get(0).getId());
        adBeanList.add(0, startBean);
        //末尾边距占位数据 图片要和第一张一样
        AdBean endBean = new AdBean();
        endBean.setPicFullPath(adBeanList.get(1).getPicFullPath());
        endBean.setAdUrl(adBeanList.get(1).getAdUrl());
        adBeanList.add(endBean);
        return adBeanList;
    }
}
