package com.hupu.tv.player.app.bean;

import java.io.Serializable;
import java.util.ArrayList;

/**
 * @author by Dell
 * @date on 2021/4/13
 * @describe
 */
public class BannerBean implements Serializable {

    /**
     * picPath : https://1-1305184012.cos.ap-nanjing.myqcloud.com/live/hth9103131783.jpg
     * adUrl : http://www.baidu.com
     * title : 惊喜好礼
     * adDes : xx-xxx充值双倍返利
     */

    private String picPath;
    private String adUrl;
    private String title;
    private String adDes;

    public String getPicPath() {
        return picPath;
    }

    public void setPicPath(String picPath) {
        this.picPath = picPath;
    }

    public String getAdUrl() {
        return adUrl;
    }

    public void setAdUrl(String adUrl) {
        this.adUrl = adUrl;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAdDes() {
        return adDes;
    }

    public void setAdDes(String adDes) {
        this.adDes = adDes;
    }


    /**
     * 为了让Viewpager轮播的时候不要出现闪屏的问题
     * 需要在真实数据的两边添加占位数据
     * 而Fragment会偶尔出现占位数据的问题
     * 所以要把占位数据设置成边界数据
     *
     * @param bannerBeans
     */
    public static ArrayList<BannerBean> dealData(ArrayList<BannerBean> bannerBeans) {
        //初始边距占位数据 图片要和最后一张一样，其他数据和第一张一样
        if (bannerBeans.size() == 0) {
            return bannerBeans;
        }
        BannerBean startBean = new BannerBean();
        startBean.setPicPath(bannerBeans.get(bannerBeans.size() - 1).getPicPath());
        startBean.setAdUrl(bannerBeans.get(0).getAdUrl());
        startBean.setAdDes(bannerBeans.get(0).getAdDes());
        startBean.setTitle(bannerBeans.get(0).getTitle());
//        startBean.setAdType(bannerBeans.get(0).getAdType());
        startBean.setAdDes(bannerBeans.get(0).getAdDes());
//        startBean.setId(bannerBeans.get(0).getId());
        bannerBeans.add(0, startBean);
        //末尾边距占位数据 图片要和第一张一样
        BannerBean endBean = new BannerBean();
        endBean.setTitle(bannerBeans.get(1).getTitle());
        endBean.setAdUrl(bannerBeans.get(1).getAdUrl());
        bannerBeans.add(endBean);
        return bannerBeans;
    }


}
