package com.hupu.tv.player.app.bean;

import java.io.Serializable;
import java.util.ArrayList;

/**
 * @author by Dell
 * @date on 2020/6/22
 * @describe
 */
public class CategoryBean implements Serializable {


    /**
     * deleted : 0
     * id : 0
     * topCategoryId : 0 //底部按钮id，1是首页，2是第二个按钮
     * topCategoryName : string //底部名字id
     * twoCategoryId : 0 //二级分类
     * twoCategoryName : string //二级名字
     */

    public static final int FIRST = 1;
    public static final int SECOND = 2;
    private int deleted;
    private int id;
    private int topCategoryId;
    private String topCategoryName;
    private int twoCategoryId;
    private int sortRank;
    private String twoCategoryName;
    private String tagIds;
    private ArrayList<TypeBean> tagMap;
    public static String TITLE = "category_title";
    public static String ID = "twoCategory_id";
    public static String TAG_ID = "tag_id";

    public String getTagIds() {
        return tagIds;
    }

    public void setTagIds(String tagIds) {
        this.tagIds = tagIds;
    }

    public ArrayList<TypeBean> getTagMap() {
        return tagMap;
    }

    public void setTagMap(ArrayList<TypeBean> tagMap) {
        this.tagMap = tagMap;
    }

    public int getDeleted() {
        return deleted;
    }

    public void setDeleted(int deleted) {
        this.deleted = deleted;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getTopCategoryId() {
        return topCategoryId;
    }

    public void setTopCategoryId(int topCategoryId) {
        this.topCategoryId = topCategoryId;
    }

    public int getSortRank() {
        return sortRank;
    }

    public void setSortRank(int sortRank) {
        this.sortRank = sortRank;
    }

    public String getTopCategoryName() {
        return topCategoryName;
    }

    public void setTopCategoryName(String topCategoryName) {
        this.topCategoryName = topCategoryName;
    }

    public int getTwoCategoryId() {
        return twoCategoryId;
    }

    public void setTwoCategoryId(int twoCategoryId) {
        this.twoCategoryId = twoCategoryId;
    }

    public String getTwoCategoryName() {
        return twoCategoryName;
    }

    public void setTwoCategoryName(String twoCategoryName) {
        this.twoCategoryName = twoCategoryName;
    }

    public class TypeBean {
        private int tagType;
        private String tagName;
        private int twoCategoryId;

        public int getTwoCategoryId() {
            return twoCategoryId;
        }

        public void setTwoCategoryId(int twoCategoryId) {
            this.twoCategoryId = twoCategoryId;
        }

        public int getTagType() {
            return tagType;
        }

        public void setTagType(int tagType) {
            this.tagType = tagType;
        }

        public String getTagName() {
            return tagName;
        }

        public void setTagName(String tagName) {
            this.tagName = tagName;
        }
    }

    /**
     * 获取第一类分级
     *
     * @param arrayList 总分类
     */
    public static ArrayList<CategoryBean> getFirstNumData(ArrayList<CategoryBean> arrayList) {
        ArrayList<CategoryBean> first = new ArrayList<>();
        for (CategoryBean categoryBean : arrayList) {
            if (categoryBean.topCategoryId == FIRST) {
                first.add(categoryBean);
            }
        }
        return first;
    }

    /**
     * 获取第二类分级
     *
     * @param arrayList 总分类
     */
    public static ArrayList<CategoryBean> getSecondNumData(ArrayList<CategoryBean> arrayList) {
        ArrayList<CategoryBean> second = new ArrayList<>();
        for (CategoryBean categoryBean : arrayList) {
            if (categoryBean.topCategoryId == SECOND) {
                second.add(categoryBean);
            }
        }
        return second;
    }

    public static ArrayList<TypeBean> getTagList(ArrayList<CategoryBean> arrayList) {
        ArrayList<TypeBean> typeBeans = new ArrayList<>();
        for (CategoryBean categoryBean : arrayList) {
            ArrayList<TypeBean> tagMap = categoryBean.getTagMap();
            if (tagMap != null && tagMap.size() != 0) {
                for (TypeBean typeBean : tagMap) {
                    typeBean.twoCategoryId = categoryBean.twoCategoryId;
                }
                typeBeans.addAll(tagMap);
            }
        }
        return typeBeans;
    }
}
