package com.hupu.tv.player.app.bean

import java.io.Serializable

/**
 * @author by Dell
 * @date on 2021/6/16
 * @describe
 */
data class MatchBasketballEntity(
        /**
         * status : 3 竞赛状态1正在进行 2未开始 3完场
         * matchTime : 20210528 10:00
         * teamMatchInfo : {"awayTeam":{"teamLogo":"https://resource.611.com/sport/Basketball/2/22.png?xossprocess=style/thumbnail_100_100&v=20210115142311","teamName":"太阳","score":95},"homeTeam":{"teamLogo":"https://resource.611.com/sport/Basketball/2/1.png?xossprocess=style/thumbnail_100_100&v=20210115142311","teamName":"湖人","score":109}}
         * homeCompetition : {"scoreSettle":"109,27,16,33,33,0","homeOrAway":"主场","result":"胜","score":109,"shots":86,"shootNum":38,"twoScore":62,"threeShots":28,"threeShotNum":7,"freeThrows":30,"freeThrowNum":26,"assists":19,"attackBoard":15,"defensiveBoard":36,"steals":10,"error":20,"blocks":4,"foul":4,"totalBoards":51}
         * homePlayerList : [{"playerName":"杰伦·史密斯","playingTime":0,"isFirst":0,"score":0,"shots":0,"shootNum":0,"twoScore":0,"threeShots":0,"threeShotNum":0,"freeThrows":0,"freeThrowNum":0,"assists":0,"attackBoard":0,"defensiveBoard":0,"steals":0,"error":0,"blocks":0,"foul":0,"totalBoards":0},{"playerName":"肖恩·亚历山大","playingTime":0,"isFirst":0,"score":0,"shots":0,"shootNum":0,"twoScore":0,"threeShots":0,"threeShotNum":0,"freeThrows":0,"freeThrowNum":0,"assists":0,"attackBoard":0,"defensiveBoard":0,"steals":0,"error":0,"blocks":0,"foul":0,"totalBoards":0},{"playerName":"卡梅隆·佩恩","playingTime":27,"isFirst":0,"score":15,"shots":11,"shootNum":6,"twoScore":0,"threeShots":5,"threeShotNum":3,"freeThrows":0,"freeThrowNum":0,"assists":6,"attackBoard":1,"defensiveBoard":0,"steals":4,"error":4,"blocks":0,"foul":1,"totalBoards":3},{"playerName":"达里奥·萨里奇","playingTime":0,"isFirst":0,"score":0,"shots":0,"shootNum":0,"twoScore":0,"threeShots":0,"threeShotNum":0,"freeThrows":0,"freeThrowNum":0,"assists":0,"attackBoard":0,"defensiveBoard":0,"steals":0,"error":0,"blocks":0,"foul":0,"totalBoards":0},{"playerName":"托里·克雷格","playingTime":15,"isFirst":0,"score":11,"shots":7,"shootNum":4,"twoScore":0,"threeShots":5,"threeShotNum":3,"freeThrows":0,"freeThrowNum":0,"assists":1,"attackBoard":1,"defensiveBoard":0,"steals":0,"error":0,"blocks":0,"foul":2,"totalBoards":4},{"playerName":"克里斯·保罗","playingTime":27,"isFirst":0,"score":7,"shots":8,"shootNum":3,"twoScore":0,"threeShots":0,"threeShotNum":0,"freeThrows":2,"freeThrowNum":1,"assists":6,"attackBoard":0,"defensiveBoard":0,"steals":1,"error":2,"blocks":0,"foul":2,"totalBoards":5},{"playerName":"杰·克劳德","playingTime":31,"isFirst":0,"score":9,"shots":9,"shootNum":2,"twoScore":0,"threeShots":7,"threeShotNum":1,"freeThrows":5,"freeThrowNum":4,"assists":2,"attackBoard":1,"defensiveBoard":0,"steals":2,"error":1,"blocks":2,"foul":5,"totalBoards":3},{"playerName":"伊托万·摩尔","playingTime":0,"isFirst":0,"score":0,"shots":0,"shootNum":0,"twoScore":0,"threeShots":0,"threeShotNum":0,"freeThrows":0,"freeThrowNum":0,"assists":0,"attackBoard":0,"defensiveBoard":0,"steals":0,"error":0,"blocks":0,"foul":0,"totalBoards":0},{"playerName":"卡梅伦·约翰逊","playingTime":17,"isFirst":0,"score":6,"shots":6,"shootNum":1,"twoScore":0,"threeShots":4,"threeShotNum":1,"freeThrows":3,"freeThrowNum":3,"assists":1,"attackBoard":0,"defensiveBoard":0,"steals":0,"error":1,"blocks":0,"foul":1,"totalBoards":2},{"playerName":"兰斯顿·加洛韦","playingTime":0,"isFirst":0,"score":0,"shots":0,"shootNum":0,"twoScore":0,"threeShots":0,"threeShotNum":0,"freeThrows":0,"freeThrowNum":0,"assists":0,"attackBoard":0,"defensiveBoard":0,"steals":0,"error":0,"blocks":0,"foul":0,"totalBoards":0},{"playerName":"德文·布克","playingTime":41,"isFirst":0,"score":19,"shots":19,"shootNum":6,"twoScore":0,"threeShots":4,"threeShotNum":1,"freeThrows":7,"freeThrowNum":6,"assists":6,"attackBoard":1,"defensiveBoard":0,"steals":0,"error":4,"blocks":0,"foul":6,"totalBoards":4},{"playerName":"米卡尔·布里奇斯","playingTime":34,"isFirst":0,"score":6,"shots":5,"shootNum":2,"twoScore":0,"threeShots":4,"threeShotNum":2,"freeThrows":0,"freeThrowNum":0,"assists":1,"attackBoard":0,"defensiveBoard":0,"steals":0,"error":0,"blocks":1,"foul":1,"totalBoards":3},{"playerName":"德安德烈·艾顿","playingTime":41,"isFirst":0,"score":22,"shots":15,"shootNum":11,"twoScore":0,"threeShots":0,"threeShotNum":0,"freeThrows":1,"freeThrowNum":0,"assists":0,"attackBoard":4,"defensiveBoard":0,"steals":1,"error":4,"blocks":2,"foul":4,"totalBoards":11},{"playerName":"杰文·卡特","playingTime":0,"isFirst":0,"score":0,"shots":0,"shootNum":0,"twoScore":0,"threeShots":0,"threeShotNum":0,"freeThrows":0,"freeThrowNum":0,"assists":0,"attackBoard":0,"defensiveBoard":0,"steals":0,"error":0,"blocks":0,"foul":0,"totalBoards":0},{"playerName":"弗兰克·卡明斯基","playingTime":7,"isFirst":0,"score":0,"shots":2,"shootNum":0,"twoScore":0,"threeShots":0,"threeShotNum":0,"freeThrows":0,"freeThrowNum":0,"assists":1,"attackBoard":0,"defensiveBoard":0,"steals":0,"error":1,"blocks":1,"foul":2,"totalBoards":0}]
         * awayCompetition : {"scoreSettle":"95,28,12,23,32,0","homeOrAway":"客场","result":"负","score":95,"shots":82,"shootNum":35,"twoScore":48,"threeShots":29,"threeShotNum":11,"freeThrows":18,"freeThrowNum":14,"assists":24,"attackBoard":8,"defensiveBoard":27,"steals":8,"error":17,"blocks":6,"foul":7,"totalBoards":35}
         * awayPlayerList : null
         */
        val status: Int,
        val matchDay: String?,
        val matchTime: String?,
        val teamMatchInfo: TeamMatchInfoEntity?,
        val homeCompetition: CompetitionEntity?,
        val awayCompetition: CompetitionEntity?,
        val awayPlayerList: ArrayList<PlayerListEntity?>?,
        val homePlayerList: ArrayList<PlayerListEntity?>?,
        val teamIntegralDto: TeamIntegralDto?,
        val matchTeamMsg: MatchTeamMsg?,
        val matchRecentDtos: ArrayList<MatchRecentDto?>?
)

/**
 * teamLogo : https://resource.611.com/sport/Basketball/2/22.png?xossprocess=style/thumbnail_100_100&v=20210115142311
 * teamName : 太阳
 * score : 95
 */
data class TeamMatchInfoEntity(
        val awayTeam: Team?,
        val matchShortName: String?,
        val homeTeam: Team?
) : Serializable

data class CompetitionEntity(
        val scoreSettle: String?,
        val homeOrAway: String?,
        val result: String?,
        val score: Int,
        val shots: Int,
        val shootNum: Int,
        val twoScore: Int,
        val threeShots: Int,
        val threeShotNum: Int,
        val freeThrows: Int,
        val freeThrowNum: Int,
        val assists: Int,
        val attackBoard: Int,
        val defensiveBoard: Int,
        val steals: Int,
        var error: Int,
        val blocks: Int,
        val foul: Int,
        val totalBoards: Int
) : Serializable




/**
 * playerName : 杰伦·史密斯
 * playingTime : 0
 * isFirst : 0
 * score : 109
 * 投篮
 * shots : 86
 * 投篮命中
 * shootNum : 38
 * 两分
 * twoScore : 62
 * 三分
 * threeShots : 28
 * 三分命中
 * threeShotNum : 7
 * 罚球
 * freeThrows : 30
 * 罚球命中
 * freeThrowNum : 26
 * 助攻
 * assists : 19
 * 助攻篮板
 * attackBoard : 15
 * 防守篮板
 * defensiveBoard : 36
 * 抢断
 * steals : 10
 * 失误
 * error : 20
 * 盖帽
 * blocks : 4
 * 犯规
 * foul : 4
 * 篮板
 * totalBoards : 51
 */
data class PlayerListEntity(
        var playerName: String?,
        var playingTime: Int,
        var isFirst: Int,
        var score: Int,
        var shots: Int,
        var shootNum: Int,
        var twoScore: Int,
        var threeShots: Int,
        var threeShotNum: Int,
        var freeThrows: Int,
        var freeThrowNum: Int,
        var assists: Int,
        var attackBoard: Int,
        var defensiveBoard: Int,
        var steals: Int,
        var error: Int,
        var blocks: Int,
        var foul: Int,
        var totalBoards: Int
) : Serializable


