package com.hupu.tv.player.app.bean

/**
 * @author by Dell
 * @date on 2022/1/4
 * @describe
 */
data class MatchContentEntity(
    val matchCount: Int?,
    val matchLists: List<MatchLists>?
)

data class MatchLists(
    val matchInfos: List<MatchInfoEntity>,
    val matchTime: String?
)

data class MatchInfoEntity(
    val awayScore: Int?,
    val awayTeam: TeamEntity?,
    val cornerKick: String?,
    val guides: List<Guide>?,
    val halftimeScore: String?,
    val homeScore: Int?,
    val startedTime: Int?,
    val homeTeam: TeamEntity?,
    val id: String?,
    val intelligence: Intelligence?,
    val matchDate: String?,
    val matchName: String?,
    val matchShortName: String?,
    val matchTime: String?,
    val result: String?,
    val sportsColor: String?,
    val sportsType: Int?,
    val status: Int?,
    var subscribe: Boolean?
)



data class Guide(
    val avatar: String?,
    val id: String?,
    val matchCutImg: String?,
    val name: String?,
    val recommend: Int?,
    val roomId: String?,
    val status: Int?
)

data class TeamEntity(
    val id: String?,
    val score: Int?,
    val teamIcon: String?,
    val teamName: String?
)

data class Intelligence(
    val away: RecentEntity?,
    val awayHistory: HistoryEntity?,
    val home: RecentEntity?,
    val homeHistory: HistoryEntity?,
    val neutral: List<Any>?
)



data class HistoryEntity(
    val lostScore: Int?,
    val recentWinRate: Int?,
    val winRate: Int?,
    val winScore: Int?
)

data class RecentEntity(
    val bad: List<Any>,
    val good: List<Any>,
    val recentRecord: List<String>?,
    val teamIcon: String?,
    val teamId: String?,
    val teamName: String?
)

