package com.hupu.tv.player.app.bean

import java.io.Serializable

/**
 * @author by Dell
 * @date on 2021/6/2
 * @describe
 */
data class MatchFootballBeanKt(
        val gameStat: List<GameStat?>?,
        val matchGameInfo: MatchGameInfo?,
        val matchGoals: List<MatchGoals?>?,
        val matchRecentDtos: ArrayList<MatchRecentDto?>?,
        val matchTeamMsg: MatchTeamMsg?,
        val teamIntegralDto: TeamIntegralDto?
)

data class MatchGameInfo(
        val competitionName: String?,
        val competitionShortName: String?,
        val matchDay: String?,
        val matchTime: String?,
        val sportType: Int?,
        val status: Int?,
        val teamInfo: TeamInfo?
)

data class MatchRecentDto(
        val competitionData: List<List<String>>?,
        val teamRecordLost: String?,
        val teamRecordName: String?,
        val teamRecordTie: String?,
        val teamRecordWin: String?
):Serializable

data class MatchTeamMsg(
        val awayMsg: Msg?,
        val homeMsg: Msg?
)

data class TeamIntegralDto(
        val awayIntegral: Integral?,
        val homeIntegral: Integral?
)

data class TeamInfo(
        val awayTeam: Team?,
        val homeTeam: Team?
)

data class Team(
        val score: Int?,
        val teamLogo: String?,
        val teamName: String?
):Serializable

data class GameStat(
        val statHome: String?,
        val statAway: String?,
        val statName: String?
):Serializable

data class MatchGoals(
        val minute:Int?,
        val eventName:String?,
        val downName:String?,
        val upName:String?,
        val type:Int?,
        val score:String?,
        val assistedName:String?,
        val pname:String?
):Serializable


data class Msg(
        val badMsg: String?,
        val goodMsg: String?
)

data class Integral(
        val header: List<String>?,
        val integralAway: List<String>?,
        val integralHome: List<String>?,
        val integralSum: List<String>?
) : Serializable