package com.hupu.tv.player.app.bean

/**
 * @author by Dell
 * @date on 2022/1/9
 * @describe
 */
data class RoomInfoEntity(
    val anchorAvatar: String,
    val anchorDesc: String,
    val anchorId: String,
    val anchorName: String,
    val follow: Boolean,
    val follows: Int,
    val hotNum: Int,
    val huanXinUserId: String,
    val liveUrl: String,
    val matchId: String,
    val matchInfo: RoomMatchInfo,
    val qqGroupNum: String,
    val qqNum: String,
    val roomAnnouncement: String,
    val globalAnnouncement: String?,
    val roomCover: String,
    val roomId: String,
    val roomName: String,
    val roomNum: String,
    val roomStatus: Int,
    val userGold: Int,
    val userId: String,
    val userLevel: Int,
    val userName: String,
    val wxNum: String
)

data class RoomMatchInfo(
    val awayScore: Int,
    val awayTeam: AwayTeam,
    val cornerKick: Any,
    val guides: List<RoomGuide>,
    val halftimeScore: Any,
    val homeScore: Int,
    val homeTeam: HomeTeam,
    val id: String,
    val intelligence: RoomIntelligence,
    val matchDate: String,
    val matchName: String,
    val matchShortName: String,
    val matchTime: String,
    val result: Any,
    val sportsColor: String,
    val sportsType: Int,
    val startedTime: Int,
    val status: Int,
    val subscribe: Boolean
)

data class AwayTeam(
    val id: String,
    val score: Int,
    val teamIcon: String,
    val teamName: String
)

data class RoomGuide(
    val avatar: String,
    val hotNum: Int,
    val id: String,
    val matchCutImg: String,
    val name: String,
    val recommend: Int,
    val roomId: String,
    val roomName: String,
    val status: Int
)

data class HomeTeam(
    val id: String,
    val score: Int,
    val teamIcon: String,
    val teamName: String
)

data class RoomIntelligence(
    val away: Away,
    val awayHistory: AwayHistory,
    val home: Home,
    val homeHistory: HomeHistory,
    val neutral: List<Any>
)

data class Away(
    val bad: List<Any>,
    val good: List<Any>,
    val recentRecord: List<String>,
    val teamIcon: String,
    val teamId: String,
    val teamName: String
)

data class AwayHistory(
    val lostScore: Int,
    val recentWinRate: Int,
    val winRate: Int,
    val winScore: Int
)

data class Home(
    val bad: List<Any>,
    val good: List<Any>,
    val recentRecord: List<String>,
    val teamIcon: String,
    val teamId: String,
    val teamName: String
)

data class HomeHistory(
    val lostScore: Int,
    val recentWinRate: Int,
    val winRate: Int,
    val winScore: Int
)