package com.hupu.tv.player.app.dataBinding


import android.view.View
import android.view.ViewGroup
import androidx.annotation.LayoutRes
import androidx.databinding.DataBindingUtil
import androidx.databinding.ViewDataBinding
import com.chad.library.adapter.base.BaseQuickAdapter
import com.softgarden.baselibrary.R
import com.softgarden.baselibrary.base.BaseRVHolder

/**
 * @author by DELL
 * @date on 2020/06/11
 * @describe 使用DataBinding的Adapter  可以通用
 */
class BaseBindAdapter<T> : BaseQuickAdapter<T, BaseRVHolder> {
    protected var variable : Int//BR


    constructor(@LayoutRes mLayoutResId: Int, variable: Int, data: List<T>?) : super(mLayoutResId, data) {
        this.variable = variable
    }

    constructor(@LayoutRes mLayoutResId: Int, variable: Int) : super(mLayoutResId) {
        this.variable = variable
    }

    override fun convert(helper: BaseRVHolder, item: T) {
        val binding = helper.itemView.getTag(R.id.BaseQuickAdapter_databinding_support) as ViewDataBinding
        binding.setVariable(variable, item)
        dataBinding(helper, binding, item, helper.layoutPosition - headerLayoutCount)
        binding.executePendingBindings()
    }

    /***
     * 该方法在 executePendingBindings 前执行
     * 所以可以重写该方法  进行其他的数据绑定
     *
     * 一般不用重写
     * @param holder
     * @param binding
     * @param item
     */
    fun dataBinding(holder: BaseRVHolder?, binding: ViewDataBinding?, item: T, position: Int) {}
    override fun getItemView(layoutResId: Int, parent: ViewGroup): View {
        val binding = DataBindingUtil.inflate<ViewDataBinding>(mLayoutInflater, layoutResId, parent, false)
                ?: return super.getItemView(layoutResId, parent)
        val view = binding.root
        view.setTag(R.id.BaseQuickAdapter_databinding_support, binding)
        return view
    }
}