package com.hupu.tv.player.app.glide;



import androidx.annotation.NonNull;

import com.bumptech.glide.Priority;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.data.DataFetcher;
import com.hupu.tv.player.app.utils.EncodeUtils2;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;

public class ImageDataFetcher implements DataFetcher<ByteBuffer> {
    private volatile boolean mIsCanceled;
    private  String webUrl;

    public ImageDataFetcher(String string) {
        webUrl = string;
    }

    /**
     * 这个方法是在非UI线程中执行,我们利用此方法来加载我们的加密数据
     *
     * @param priority
     * @throws Exception
     */


    @Override
    public void loadData(@NonNull Priority priority, @NonNull DataCallback<? super ByteBuffer> callback) {
        if (mIsCanceled) {
            return;
        }
        try {
            URL url = new URL(webUrl);
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            //设置网络请求方式，如GET、POST、HEAD等
            conn.setRequestMethod("GET");
            //设置连接超时时间
            conn.setConnectTimeout(8000);
            //设置读取超时时间
            conn.setReadTimeout(8000);
            callback.onDataReady(new EncodeUtils2().decryptUrl(conn.getInputStream()));
        } catch (IOException e) {
            e.printStackTrace();
        }

    }


    /**
     * 处理完成之后清理工作
     */
    @Override
    public void cleanup() {
//        if (mInputStream != null) {
//            try {
//                mInputStream.close();
//            } catch (IOException e) {
//                Log.e("Glide", "Glide", e);
//            } finally {
//                mInputStream = null;
//            }
//        }
    }


    /**
     * 在UI线程中调用，取消加载任务
     */
    @Override
    public void cancel() {
        mIsCanceled = true;
    }

    @NonNull
    @Override
    public Class<ByteBuffer> getDataClass() {
        return ByteBuffer.class;
    }

    @NonNull
    @Override
    public DataSource getDataSource() {
        return DataSource.REMOTE;
    }
}