package com.hupu.tv.player.app.ui

import android.content.Context
import android.content.Intent
import android.content.res.Configuration
import android.graphics.Color
import android.view.View
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.base.FragmentBasePagerAdapter
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.dialog.PromptDialog
import com.softgarden.baselibrary.network.NetworkTransformer
import com.softgarden.baselibrary.network.RxCallback
import com.softgarden.baselibrary.utils.DisplayUtil
import com.softgarden.baselibrary.utils.L
import com.softgarden.baselibrary.utils.ToastUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.api.RetrofitClient
import com.hupu.tv.player.app.base.ToolbarActivity
import com.hupu.tv.player.app.bean.ImageBean
import com.hupu.tv.player.app.ui.testMvp.TestMvpActivity
import kotlinx.android.synthetic.main.activity_test_toolbar.*

class TestToolbarActivity <P:IBasePresenter>: ToolbarActivity<P>() {

    override val baseActivity: BaseActivity<*>?
        get() = this
    override val ctx: Context?
        get() = this
    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return builder // .setStatusBarColor(Color.GRAY)
                //                .addLeftText("语言切换", v -> {
                //                    Locale locale = isEqualsLanguage(BaseSPManager.getLanguage(), Locale.SIMPLIFIED_CHINESE) ? Locale.ENGLISH : Locale.SIMPLIFIED_CHINESE;
                //                    changeLanguage(locale);
                //                    reload();//要重新启动Activity
                //                })
                .addRightText("日夜切换") { v: View? ->
//                    changeDayNightMode(!BaseSPManager.isNightMode());
                    reload()
                }
                .addRightImage(R.mipmap.more) { v: View? -> TestMvpActivity.Companion.start(this) }
                .setBottomDivider(Color.parseColor("#E4DFE1"), DisplayUtil.dip2px(this, 3f))
                .setTitleTextColor(Color.WHITE)
                .setTitle(R.string.app_name)
    }

    override val layoutId: Int
        get() =  R.layout.activity_test_toolbar

    override fun onConfigurationChanged(newConfig: Configuration) {
        super.onConfigurationChanged(newConfig)
        L.d("onConfigurationChanged")
    }

    override fun initialize() {
        // getToolbar().getRightView(0).setBackgroundColor(Color.GRAY);
        val title = arrayOf("标题1", "标题2", "标题3", "标题4")
        val adapter = FragmentBasePagerAdapter(supportFragmentManager, listOf(TestFragment.newInstance()), title)
        mViewPager.adapter = adapter
        mViewPager.offscreenPageLimit = adapter.count
        mTabLayout.setupWithViewPager(mViewPager)
        // loadData();
//        val userBean = UserBean("1", "testName", 18, true)
        val key = "UseBean"
//        SPUtil.putSerializableObject(key, userBean)
//        val userBean1: UserBean? = SPUtil.getSerializableObject(key)
        //        L.d(userBean1.getName());
//        L.d(userBean1.isCheck() + "");
//        L.d(userBean1.toString());


        //    showPromptDialog();
    }

    private fun showPromptDialog() {
        PromptDialog(this)
                .setTitle("标题")
                .setContent("内容")
                .setPositiveButton("确定")
                .setNegativeButton("取消")
                .setOnButtonClickListener(object :PromptDialog.OnButtonClickListener{
                    override fun onButtonClick(dialog: PromptDialog?, isPositiveClick: Boolean) {
                        ToastUtil.s("dianji")
                    }
                }).show()

    }

    private fun loadData() {
        RetrofitClient.retrofitService
                .data
                .compose<List<ImageBean>>(NetworkTransformer(this))
                .subscribe(object : RxCallback<List<ImageBean?>?>() {
                    override fun onSuccess(data: List<ImageBean?>?) {}
                })
    }

    companion object {
        fun start(context: Context) {
            val starter = Intent(context, TestToolbarActivity::class.java)
            //        starter.putExtra();
            context.startActivity(starter)
        }
    }
}