package com.hupu.tv.player.app.ui.activity

import android.content.Context
import com.hupu.tv.player.app.BuildConfig
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.utils.ProductFlavors
import kotlinx.android.synthetic.main.activity_about.*
import kotlinx.android.synthetic.main.layout_title.*


class AboutActivity : RefreshActivity<IBasePresenter>(), IBaseDisplay {
    override fun loadData() {

    }

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override val layoutId: Int
        get() = R.layout.activity_about

    override fun initialize() {
        setStatus()
        tv_title_middle.text = "关于"
        tv_title_middle.setTextColor(resources.getColor(R.color.black))
        iv_left_icon.setOnClickListener {
            finish()
        }
        tv_name.text = ProductFlavors.getString(ProductFlavors.APP_NAME)
        tv_version.text = BuildConfig.VERSION_NAME

    }

    override val ctx: Context?
        get() = this
    override val baseActivity: BaseActivity<*>?
        get() = this

}