package com.hupu.tv.player.app.ui.activity

import android.content.Context
import android.text.TextUtils
import cc.taylorzhang.singleclick.onSingleClick
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.utils.SPUtil
import com.softgarden.baselibrary.utils.ToastUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.ui.contact.AccountBindContact
import com.hupu.tv.player.app.ui.presenter.AccountBindPresenter
import kotlinx.android.synthetic.main.activity_account_bind.*
import kotlinx.android.synthetic.main.layout_title.*


class AccountBindActivity : RefreshActivity<AccountBindPresenter>(), AccountBindContact.Display {
    override fun loadData() {

    }

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override val layoutId: Int
        get() = R.layout.activity_account_bind

    override fun initialize() {
        val phone = SPUtil[Constants.USER_PHONE, ""] as String
        val startPhone = phone.subSequence(0, 3)
        val endPhone = phone.subSequence(9, 11)
        tv_phone.text = " ${startPhone}******${endPhone}"
        setStatus()
        tv_title_middle.text = "改绑手机"
        tv_title_middle.setTextColor(resources.getColor(R.color.black))
        iv_left_icon.setOnClickListener {
            finish()
        }

        tv_verify.onSingleClick {
            val code = et_login_code.text.toString()
            if (TextUtils.isEmpty(code)) {
                ToastUtil.s("请填入验证码")
                return@onSingleClick
            }
            presenter?.verifySmsCode(code)
        }
        tv_get_code.onSingleClick {
            presenter?.getSmsCode(phone)
            tv_get_code.start()
        }
    }

    override fun onSmsCodeSuccess() {
        startActivity(AccountBindNewPhoneActivity::class.java)
        finish()
    }

    override val ctx: Context?
        get() = this
    override val baseActivity: BaseActivity<*>?
        get() = this

}