package com.hupu.tv.player.app.ui.activity

import android.content.Context
import android.text.TextUtils
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.utils.CheckUtil
import com.softgarden.baselibrary.utils.ToastUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.ui.contact.AccountBindNewPhoneContact
import com.hupu.tv.player.app.ui.presenter.AccountBindNewPhonePresenter
import com.hupu.tv.player.app.utils.CommonUtils
import kotlinx.android.synthetic.main.activity_account_bind_new_phone.*
import kotlinx.android.synthetic.main.layout_title.*


class AccountBindNewPhoneActivity : RefreshActivity<AccountBindNewPhonePresenter>(), AccountBindNewPhoneContact.Display {
    private var phone = ""
    override fun loadData() {

    }

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override val layoutId: Int
        get() = R.layout.activity_account_bind_new_phone

    override fun initialize() {
        setStatus()
        tv_title_middle.text = "绑定新手机"
        tv_title_middle.setTextColor(resources.getColor(R.color.black))
        iv_left_icon.setOnClickListener {
            finish()
        }

        tv_confirm.setOnClickListener {
            phone = et_new_phone.text.toString()
            if (CheckUtil.isIllegalPhone(phone, "请填入正确的手机号")) {
                return@setOnClickListener
            }

            val code = et_code.text.toString()
            if (TextUtils.isEmpty(code)) {
                ToastUtil.s("请填入验证码")
                return@setOnClickListener
            }
            presenter?.bindNewPhone(code, phone)
        }
        tv_get_code.setOnClickListener {
            phone = et_new_phone.text.toString()
            if (CheckUtil.isIllegalPhone(phone, "请填入正确的手机号")) {
                return@setOnClickListener
            }
            presenter?.getSmsCode(phone)
            tv_get_code.start()
        }
    }

    override fun onBind() {
        CommonUtils.umengLogin()
        ToastUtil.s("绑定成功")
        finish()
    }

    override val ctx: Context?
        get() = this
    override val baseActivity: BaseActivity<*>?
        get() = this

}