package com.hupu.tv.player.app.ui.activity

import android.content.Context
import android.text.TextUtils
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.utils.SPUtil
import com.softgarden.baselibrary.utils.ToastUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.ui.contact.AccountBindContact
import com.hupu.tv.player.app.ui.presenter.AccountBindPresenter
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import kotlinx.android.synthetic.main.activity_account_setting.*
import kotlinx.android.synthetic.main.layout_title.*


class AccountSettingActivity : RefreshActivity<IBasePresenter>(),IBaseDisplay {
    override fun loadData() {

    }

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override val layoutId: Int
        get() = R.layout.activity_account_setting

    override fun initialize() {
        tv_title_middle.text = "账号与绑定"
        tv_title_middle.setTextColor(resources.getColor(R.color.black))
        iv_left_icon.setOnClickListener {
            finish()
        }
        ll_change_phone.setOnClickListener {
            startActivity(AccountBindActivity::class.java)
        }
        ll_setting_password.setOnClickListener {
            startActivity(SettingPasswordActivity::class.java)
        }
        ll_edit_password.setOnClickListener {
            startActivity(EditPasswordActivity::class.java)
        }
        ll_forget_password.setOnClickListener {
            startActivity(ForgetPasswordActivity::class.java)
        }




    }

    override val ctx: Context?
        get() = this
    override val baseActivity: BaseActivity<*>?
        get() = this

}