package com.hupu.tv.player.app.ui.activity

import android.content.Context
import android.content.Intent
import android.graphics.Bitmap
import android.text.TextUtils
import com.bumptech.glide.Glide
import com.bumptech.glide.request.target.SimpleTarget
import com.bumptech.glide.request.transition.Transition
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.bean.AdBean
import kotlinx.android.synthetic.main.activity_agent.*
import kotlinx.android.synthetic.main.layout_title.*


class


AgentActivity : RefreshActivity<IBasePresenter>(), IBaseDisplay {
    override fun loadData() {

    }

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override val layoutId: Int
        get() = R.layout.activity_agent

    override fun initialize() {
        setStatus()
        tv_title_middle.text = "邀请赚钱"
        tv_title_middle.setTextColor(resources.getColor(R.color.black))
        iv_left_icon.setOnClickListener {
            finish()
        }
        ll_share.setOnClickListener {
            startActivity(Intent(this, ShareActivity::class.java))
            finish()
        }
        tv_my_withdraw.setOnClickListener {
            startActivity(Intent(this, WithdrawActivity::class.java))
            finish()
        }
        val agentAd: AdBean? = AdBean.getAgentAd(SPUtil.getSerializableObject<ArrayList<AdBean>>(Constants.AD_LIST))
//        val pic = "${SPUtil[Constants.SITE, ""]}${agentAd?.picPath}"
        val pic = agentAd?.picFullPath
//        if (TextUtils.isEmpty(agentAd?.picPath)) {
        if (TextUtils.isEmpty(pic)) {
//            iv_agent.setImageDrawable(resources.getDrawable(R.mipmap.bg_agent))
        } else {
            Glide.with(activity).asBitmap().load(pic).into(object : SimpleTarget<Bitmap?>() {
                override fun onResourceReady(resource: Bitmap, transition: Transition<in Bitmap?>?) {
                    iv_agent.setImageBitmap(resource)
                }
            })
        }
    }

    override val ctx: Context?
        get() = this
    override val baseActivity: BaseActivity<*>?
        get() = this

}