package com.hupu.tv.player.app.ui.activity

import android.content.Context
import android.telephony.PhoneNumberUtils
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.utils.ToastUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.ui.contact.BindPhoneContact
import com.hupu.tv.player.app.ui.presenter.BindPhonePresenter
import kotlinx.android.synthetic.main.activity_bind_phone.*
import kotlinx.android.synthetic.main.layout_title.*
import java.util.regex.Matcher
import java.util.regex.Pattern



class BindPhoneActivity : RefreshActivity<BindPhonePresenter>(), BindPhoneContact.Display {
    override fun loadData() {

    }

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override val layoutId: Int
        get() = R.layout.activity_bind_phone

    override fun initialize() {
        setStatus()
        tv_title_middle.text = "绑定手机"
        iv_left_icon.setOnClickListener {
            finish()
        }
        setListener()
    }

    private fun setListener() {
        //发送验证码
        tv_code.setOnClickListener {
            val phoneNumber: String? = et_phone_number.text.toString()
            if (phoneNumber == null || phoneNumber.isEmpty()) {
                ToastUtil.s("请输入手机号码")
                return@setOnClickListener
            }

            if (verifyPhone(phoneNumber)) {
                presenter?.getCode(phoneNumber)
            } else {
                ToastUtil.s("请输入正确的手机号码")
            }

        }
        tv_confirm.setOnClickListener {
            val verifyCode: String? = et_verify.text.toString()
            if (verifyCode == null || verifyCode.isEmpty()) {
                ToastUtil.s("请输入验证码")
            } else {
                presenter?.commitBindPhone(verifyCode)
            }

        }
    }


    private fun verifyPhone(phoneNo: String): Boolean {
        if (phoneNo.length == 11) {
            for (i in 0..10) {
                //是否为0-9
                if (!PhoneNumberUtils.isISODigit(phoneNo[i])) {
                    return false
                }
            }
            val p: Pattern = Pattern.compile("^((13[^4,\\D])" + "|(134[^9,\\D])" +
                    "|(14[5,7])" +
                    "|(15[^4,\\D])" +
                    "|(17[3,6-8])" +
                    "|(18[0-9]))\\d{8}$")
            val m: Matcher = p.matcher(phoneNo)
            return m.matches()
        }
        return false
    }

    override fun onTick(second: Long) {
        tv_code.text = second.toString()
        tv_code.isClickable = false
    }

    override fun onFinish() {
        tv_code.isClickable = true
        tv_code.text = "重新获取"
    }

    override fun onBindFinish() {
        ToastUtil.s("手机绑定成功")
        setResult(RESULT_OK, intent)
        finish()
    }


    override val ctx: Context?
        get() = this
    override val baseActivity: BaseActivity<*>?
        get() = this

}