package com.hupu.tv.player.app.ui.activity

import android.content.Context
import androidx.recyclerview.widget.LinearLayoutManager

import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.bean.BoardBean
import com.hupu.tv.player.app.ui.adapter.BoardListAdapter
import com.hupu.tv.player.app.ui.contact.BoardActivityContact
import com.hupu.tv.player.app.ui.presenter.BoardActivityPresenter
import kotlinx.android.synthetic.main.activity_board.*
import kotlinx.android.synthetic.main.layout_title.*

class BoardActivity : RefreshActivity<BoardActivityPresenter>(), BoardActivityContact.DisPlay {

    override fun loadData() {

    }
    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }
    override val layoutId: Int
        get() = R.layout.activity_board

    override fun initialize() {
        setStatus()
        tv_title_middle.text = "公告列表"
        iv_left_icon.setOnClickListener { finish() }
        val boardList = SPUtil.getSerializableObject<ArrayList<BoardBean>>(Constants.BOARD_LIST)
        boardList.let {
            val adapter = BoardListAdapter(R.layout.item_board_list, it)
            recycler_board?.layoutManager = LinearLayoutManager(activity)
            recycler_board?.adapter = adapter
        }

    }
    override val ctx: Context?
        get() = this
    override val baseActivity: BaseActivity<*>?
        get() = this
}