package com.hupu.tv.player.app.ui.activity


import android.content.Context
import android.content.Intent
import android.text.Spannable
import android.text.SpannableStringBuilder
import android.text.TextUtils
import android.text.method.HideReturnsTransformationMethod
import android.text.method.LinkMovementMethod
import android.text.style.ClickableSpan
import android.text.style.ForegroundColorSpan
import android.util.Log
import android.view.View
import cc.taylorzhang.singleclick.onSingleClick
import com.kongzue.dialog.v3.WaitDialog
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.utils.CheckUtil
import com.softgarden.baselibrary.utils.ToastUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.ui.contact.EdittPasswordActivityContact
import com.hupu.tv.player.app.ui.contact.ForgetPasswordActivityContact
import com.hupu.tv.player.app.ui.contact.LoginActivityContact
import com.hupu.tv.player.app.ui.presenter.EdittPasswordActivityPresenter
import com.hupu.tv.player.app.ui.presenter.ForgetPasswordActivityPresenter
import com.hupu.tv.player.app.utils.CommonUtils
import com.hupu.tv.player.app.utils.DialogUtils
import com.mirkowu.statusbarutil.StatusBarUtil
import com.quanmingxing.app.widget.widget.BiggerDotPasswordTransformationMethod
import com.softgarden.baselibrary.base.BaseActivity
import kotlinx.android.synthetic.main.activity_edit_password.*


class EditPasswordActivity : RefreshActivity<EdittPasswordActivityPresenter>(),
    EdittPasswordActivityContact.Display {
    override val layoutId: Int
        get() = R.layout.activity_edit_password

    override val baseActivity: BaseActivity<*>
        get() = this



    override fun onEditPassword() {
        ToastUtil.s("密码修改成功")
        finish()
    }

    override val ctx: Context?
        get() = this

    override fun initialize() {
        initListener()
    }
    override fun onResume() {
        super.onResume()
        StatusBarUtil.setStatusBarColor(this,getColor(R.color.color_F5F6F7))
        StatusBarUtil.setStatusBarLightMode(this,3)
    }

    private fun initListener() {
        et_edit_password.transformationMethod = BiggerDotPasswordTransformationMethod()
        iv_show_password.setOnClickListener {
            iv_show_password.isSelected = !iv_show_password.isSelected
            if (iv_show_password.isSelected) {
                et_edit_password.transformationMethod = HideReturnsTransformationMethod.getInstance()
            } else {
                et_edit_password.transformationMethod = BiggerDotPasswordTransformationMethod()
            }
        }
        iv_back.setOnClickListener {
            onBackPressed()
        }
        et_edit_password_confirm.transformationMethod = BiggerDotPasswordTransformationMethod()
        iv_show_password_confirm.setOnClickListener {
            iv_show_password_confirm.isSelected = !iv_show_password_confirm.isSelected
            if (iv_show_password_confirm.isSelected) {
                et_edit_password_confirm.transformationMethod = HideReturnsTransformationMethod.getInstance()
            } else {
                et_edit_password_confirm.transformationMethod = BiggerDotPasswordTransformationMethod()
            }
        }



        iv_edit_password.onSingleClick {
            when {
                CheckUtil.isIllegalPhone(et_phone_number.text.toString(), "请填入正确的手机号") -> ""
                et_edit_code.text.isNullOrEmpty() -> ToastUtil.s("请填入验证码")
                et_edit_password.text.isNullOrEmpty() -> ToastUtil.s("请输入密码")
                et_edit_password_confirm.text.isNullOrEmpty() -> ToastUtil.s("请再次输入密码")
                et_edit_password.text.toString() != et_edit_password_confirm.text.toString() -> ToastUtil.s("两次密码输入不相同")
                else -> presenter?.editPassword(
                    et_phone_number.text.toString(),
                    et_edit_code.text.toString(),
                    et_edit_password.text.toString()
                )
            }
        }
        tv_get_code.onSingleClick {
            if (!CheckUtil.isIllegalPhone(et_phone_number.text.toString(), "请填入正确的手机号")) {
                presenter?.getSmsCode(et_phone_number.text.toString())
                tv_get_code.start()
            }
        }
    }


    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override fun loadData() {

    }
}