package com.hupu.tv.player.app.ui.activity

import android.content.Context
import android.text.TextUtils
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.utils.SPUtil
import com.softgarden.baselibrary.utils.ToastUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.bean.LiveUserBean
import com.hupu.tv.player.app.ui.contact.EditNickContact
import com.hupu.tv.player.app.ui.presenter.EditNickPresenter
import kotlinx.android.synthetic.main.activity_edit_nick.*
import kotlinx.android.synthetic.main.layout_title.*


class EditUserNickNameActivity : RefreshActivity<EditNickPresenter>(), EditNickContact.Display {
    override fun loadData() {

    }

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override val layoutId: Int
        get() = R.layout.activity_edit_nick

    override fun initialize() {
        setStatus()
        tv_title_middle.text = "修改昵称"
        tv_title_middle.setTextColor(resources.getColor(R.color.black))
        iv_left_icon.setOnClickListener {
            finish()
        }
        val userBean = SPUtil.getSerializableObject<LiveUserBean>(Constants.LIVE_USER_BEAN)
        et_input_nickname.hint = userBean?.userName
        tv_save.setOnClickListener {
            if (TextUtils.isEmpty(et_input_nickname.text.toString())) {
                ToastUtil.s("请输入新昵称")
                return@setOnClickListener
            }
            presenter?.editInfo(et_input_nickname.text.toString(), userBean?.sex
                    ?: 0, userBean?.birthday ?: "")

        }
    }

    override fun onSuccess() {
        ToastUtil.s("修改成功")
        finish()
    }

    override val ctx: Context?
        get() = this
    override val baseActivity: BaseActivity<*>?
        get() = this

}