package com.hupu.tv.player.app.ui.activity

import android.content.Context
import android.text.TextUtils
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.utils.ToastUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.ui.contact.ExchangeCodeActivityContact
import com.hupu.tv.player.app.ui.presenter.ExchangeCodeActivityPresenter
import kotlinx.android.synthetic.main.activity_exchange_code.*
import kotlinx.android.synthetic.main.layout_title.*

class ExchangeCodeActivity : RefreshActivity<ExchangeCodeActivityPresenter>(), ExchangeCodeActivityContact.Display {
    override fun loadData() {

    }

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override val layoutId: Int
        get() = R.layout.activity_exchange_code

    override fun initialize() {
        setStatus()
        tv_title_middle.text = "兑换码"
        iv_left_icon.setOnClickListener { finish() }
        tv_exchange_code.setOnClickListener {
            val text = et_share_code.text.toString()
            if (TextUtils.isEmpty(text)){
                ToastUtil.s("请输入兑换码")
            }else{
                presenter?.exchangeCode(text)
            }

        }
    }

    override fun onExchangeCode() {
        ToastUtil.s("兑换成功")
        finish()
    }

    override val ctx: Context?
        get() = this
    override val baseActivity: BaseActivity<*>?
        get() = this

}