package com.hupu.tv.player.app.ui.activity

import android.content.Context
import android.text.Editable
import android.text.TextUtils
import android.text.TextWatcher
import android.view.View
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.utils.ToastUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.ui.contact.ExchangeShareActivityContact
import com.hupu.tv.player.app.ui.presenter.ExchangeShareActivityPresenter
import kotlinx.android.synthetic.main.activity_exchange_share.*
import kotlinx.android.synthetic.main.layout_title.*

class ExchangeShareActivity : RefreshActivity<ExchangeShareActivityPresenter>(), ExchangeShareActivityContact.Display {
    override fun loadData() {

    }

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override val layoutId: Int
        get() = R.layout.activity_exchange_share

    override fun initialize() {
        setStatus()
        tv_title_middle.text = "兑换码"
        iv_left_icon.setOnClickListener { finish() }
        presenter?.getShareNum()
        tv_exchange.setOnClickListener {
            presenter?.exchangeShare()
        }
        view_front.visibility = View.VISIBLE
        tv_exchange_code.setOnClickListener {
            val text = et_share_code.text.toString()
            if (TextUtils.isEmpty(text)){
                ToastUtil.s("请输入兑换码")
            }else{
                presenter?.exchangeCode(text)
            }
        }
        et_share_code.addTextChangedListener(object :TextWatcher{
            override fun afterTextChanged(p0: Editable?) {
                if (TextUtils.isEmpty(p0)){
                    view_front.visibility = View.VISIBLE
                }else{
                    view_front.visibility = View.GONE
                }
            }
            override fun beforeTextChanged(p0: CharSequence?, p1: Int, p2: Int, p3: Int) {
            }

            override fun onTextChanged(p0: CharSequence?, p1: Int, p2: Int, p3: Int) {

            }
        })
    }

    override fun onShareNum(count: Int?) {
        count?.let {
            tv_nums.text = it.toString() + "人"
        }
    }

    override fun onExchangeCode() {
        ToastUtil.s("兑换成功")
        presenter?.refreshUserInfo()
    }

    override fun onExchangeShare(isSuccess: Boolean?) {
        isSuccess?.let {
            if (it) {
                ToastUtil.s("兑换成功")
                presenter?.refreshUserInfo()
            } else {
                ToastUtil.s("兑换失败")
            }
        }


    }

    override val ctx: Context?
        get() = this
    override val baseActivity: BaseActivity<*>?
        get() = this

}