package com.hupu.tv.player.app.ui.activity

import android.content.Context
import android.content.Intent
import android.text.Editable
import android.text.TextWatcher
import android.view.View
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.bean.AnchorEntity
import com.hupu.tv.player.app.bean.LiveBean
import com.hupu.tv.player.app.bean.ReportEntity
import com.hupu.tv.player.app.ui.adapter.AnchorAdapter
import com.hupu.tv.player.app.ui.adapter.ReportAdapter
import com.hupu.tv.player.app.ui.contact.FollowAnchorContract
import com.hupu.tv.player.app.ui.presenter.FollowAnchorPresenter
import com.hupu.tv.player.app.utils.EmptyConfig
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.utils.RecyclerViewUtil
import com.softgarden.baselibrary.utils.ToastUtil
import kotlinx.android.synthetic.main.activity_report.*
import kotlinx.android.synthetic.main.layout_title_live.*


class FollowActivity : RefreshActivity<FollowAnchorPresenter>(), FollowAnchorContract.Display {
    private var anchorAdapter: AnchorAdapter? = null

    override fun loadData() {
        presenter?.getAnchorList()
    }

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override val layoutId: Int
        get() = R.layout.activity_follow

    override fun initialize() {
        initRefreshLayout()
        initRecyclerView()
        initAdapter()
        tv_title_middle.text = "我的关注"
        iv_left_icon.setOnClickListener {
            finish()
        }

        initStatusLayout(mRefreshLayout as View)
        mStatusLayoutManager.showLoadingLayout()
    }



    private fun initAdapter() {
        anchorAdapter = AnchorAdapter()
        mRecyclerView?.adapter = anchorAdapter
        if (mRecyclerView?.itemDecorationCount == 0) {
            RecyclerViewUtil.addItemDecoration(this, mRecyclerView!!, R.color.color_E9E9E9, 1)
        }
        anchorAdapter?.setOnItemClickListener { adapter, view, position ->
            val anchorEntity = adapter.getItem(position) as AnchorEntity
            if (anchorEntity.liveStatus == 0) {
                ToastUtil.s("您关注的主播未开播")
                return@setOnItemClickListener
            }
            val intent = Intent(activity, LiveActivity::class.java)
            intent.putExtra(Constants.ROOM_ID, anchorEntity.roomId)
            intent.putExtra(Constants.ROOM_COVER, anchorEntity.matchCutImg)
            startActivity(intent)
        }

    }

    override fun onAnchorList(list: List<AnchorEntity>) {
        mStatusLayoutManager.showSuccessLayout()
        anchorAdapter?.let {
            setLoadData(it, list, EmptyConfig.NO_FOLLOW_ANCHOR)
        }
    }

    override fun onRecommendList(list: List<LiveBean.DataListBean>) {

    }

    override val ctx: Context?
        get() = this
    override val baseActivity: BaseActivity<*>?
        get() = this

}