package com.hupu.tv.player.app.ui.activity


import android.content.Context
import android.content.Intent
import android.text.Spannable
import android.text.SpannableStringBuilder
import android.text.TextUtils
import android.text.method.HideReturnsTransformationMethod
import android.text.method.LinkMovementMethod
import android.text.style.ClickableSpan
import android.text.style.ForegroundColorSpan
import android.util.Log
import android.view.View
import cc.taylorzhang.singleclick.onSingleClick
import com.kongzue.dialog.v3.WaitDialog
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.utils.CheckUtil
import com.softgarden.baselibrary.utils.ToastUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.ui.contact.ForgetPasswordActivityContact
import com.hupu.tv.player.app.ui.contact.LoginActivityContact
import com.hupu.tv.player.app.ui.presenter.ForgetPasswordActivityPresenter
import com.hupu.tv.player.app.utils.CommonUtils
import com.hupu.tv.player.app.utils.DialogUtils
import com.mirkowu.statusbarutil.StatusBarUtil
import com.quanmingxing.app.widget.widget.BiggerDotPasswordTransformationMethod
import com.softgarden.baselibrary.base.BaseActivity
import kotlinx.android.synthetic.main.activity_forget_password.*


class ForgetPasswordActivity : RefreshActivity<ForgetPasswordActivityPresenter>(),
    ForgetPasswordActivityContact.Display {
    override val layoutId: Int
        get() = R.layout.activity_forget_password

    override val baseActivity: BaseActivity<*>
        get() = this

    override fun onForgetPassword() {
        ToastUtil.s("密码重置成功")
        finish()

    }

    override fun onVerficationSmsCode() {

    }

    override val ctx: Context?
        get() = this

    override fun initialize() {
        initListener()
    }
    override fun onResume() {
        super.onResume()
        StatusBarUtil.setStatusBarColor(this,getColor(R.color.color_F5F6F7))
        StatusBarUtil.setStatusBarLightMode(this,3)
    }


    private fun initListener() {
        et_forget_password.transformationMethod = BiggerDotPasswordTransformationMethod()
        iv_show_password.setOnClickListener {
            iv_show_password.isSelected = !iv_show_password.isSelected
            if (iv_show_password.isSelected) {
                et_forget_password.transformationMethod = HideReturnsTransformationMethod.getInstance()
            } else {
                et_forget_password.transformationMethod = BiggerDotPasswordTransformationMethod()
            }
        }

        iv_back.setOnClickListener {
            onBackPressed()
        }

        iv_forget.onSingleClick {
            when {
                CheckUtil.isIllegalPhone(et_forget_phone.text.toString(), "请填入正确的手机号") -> ""
                et_forget_code.text.isNullOrEmpty() -> ToastUtil.s("请填入验证码")
                et_forget_password.text.length < 6 || et_forget_password.text.length > 24 -> ToastUtil.s(
                    "请输入6-15位密码"
                )
                else -> presenter?.forgetPassword(
                    et_forget_phone.text.toString(),
                    et_forget_code.text.toString(),
                    et_forget_password.text.toString()
                )
            }
        }
        tv_get_code.onSingleClick {
            if (!CheckUtil.isIllegalPhone(et_forget_phone.text.toString(), "请填入正确的手机号")) {
                presenter?.getSmsCode(et_forget_phone.text.toString())
                tv_get_code.start()
            }
        }
    }


    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override fun loadData() {

    }
}