package com.hupu.tv.player.app.ui.activity

import android.content.Context
import android.content.Intent

import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import androidx.viewpager.widget.PagerAdapter
import androidx.viewpager.widget.ViewPager
import com.mirkowu.statusbarutil.StatusBarUtil
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.utils.BaseSPManager
import com.hupu.tv.player.app.utils.DeviceUtils
import com.softgarden.baselibrary.utils.L
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.utils.ImageUtil
import kotlinx.android.synthetic.main.activity_guide.*

class GuideActivity<P : IBasePresenter> : BaseActivity<IBasePresenter>(), ViewPager.OnPageChangeListener {

    private var adapter: ImagePagerAdapter? = null
    override val layoutId: Int
        get() = R.layout.activity_guide

    override val baseActivity: BaseActivity<*>?
        get() = this
    override val ctx: Context?
        get() = this

    override fun initialize() {
//        L.e("device-id", DeviceUtils.getDeviceId(this))

        StatusBarUtil.setImmersiveTransparentStatusBar(this)
        adapter = ImagePagerAdapter()
        mViewPager.offscreenPageLimit = adapter!!.count
        mViewPager.adapter = adapter
        mViewPager.addOnPageChangeListener(this)
        tvStart.setOnClickListener {
            BaseSPManager.isFirstLaunch = false
            MainActivity.Companion.start(activity)
            this@GuideActivity.finish()
        }
    }

    override fun onPageScrolled(position: Int, positionOffset: Float, positionOffsetPixels: Int) {}
    override fun onPageSelected(position: Int) {
        tvStart!!.isEnabled = position == adapter!!.count - 1
    }

    override fun onPageScrollStateChanged(state: Int) {}

    inner class ImagePagerAdapter : PagerAdapter() {
        var resId = intArrayOf(R.mipmap.header1, R.mipmap.header2, R.mipmap.header3)
        override fun getCount(): Int {
            return resId.size
        }

        //  来判断显示的是否是同一张图片，这里我们将两个参数相比较返回即可
        override fun isViewFromObject(arg0: View, arg1: Any): Boolean {
            return arg0 === arg1
        }

        //  PagerAdapter只缓存三张要显示的图片，如果滑动的图片超出了缓存的范围，就会调用这个方法，将图片销毁
        override fun destroyItem(view: ViewGroup, position: Int, `object`: Any) {
            view.removeView(`object` as View)
        }

        //  当要显示的图片可以进行缓存的时候，会调用这个方法进行显示图片的初始化，我们将要显示的ImageView加入到ViewGroup中，然后作为返回值返回即可
        override fun instantiateItem(view: ViewGroup, position: Int): Any {
            val imageView = ImageView(view.context)
            imageView.scaleType = ImageView.ScaleType.CENTER_CROP
            ImageUtil.loadSrc(imageView, resId[position]) //viewPager直接加载大图会导致卡顿，可使用第三方工具加载
            view.addView(imageView)
            return imageView
        }
    }

    companion object {
        fun start(context: Context) {
            val starter = Intent(context, GuideActivity::class.java)
            //	    starter.putExtra( );
            context.startActivity(starter)
        }
    }
}