package com.hupu.tv.player.app.ui.activity

import android.content.Context
import android.content.Intent
import android.content.res.Configuration
import android.text.TextUtils
import android.view.View
import android.widget.TextView
import androidx.appcompat.app.AppCompatActivity
import androidx.fragment.app.Fragment
import cc.taylorzhang.singleclick.onSingleClick
import com.flyco.tablayout.listener.OnTabSelectListener
import com.flyco.tablayout.utils.FragmentBasePager2Adapter
import com.hyphenate.EMCallBack
import com.hyphenate.chat.EMClient
import com.kongzue.dialog.util.BaseDialog
import com.kongzue.dialog.v3.CustomDialog
import com.mirkowu.basetoolbar.BaseToolbar
import com.shuyu.gsyvideoplayer.GSYVideoManager
import com.shuyu.gsyvideoplayer.listener.GSYSampleCallBack
import com.shuyu.gsyvideoplayer.utils.OrientationUtils
import com.shuyu.gsyvideoplayer.video.base.GSYVideoPlayer
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.utils.SPUtil
import com.softgarden.baselibrary.utils.ToastUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.bean.GiftBean
import com.hupu.tv.player.app.bean.HistoryMessageEntity
import com.hupu.tv.player.app.bean.RoomInfoEntity
import com.hupu.tv.player.app.event.FollowAnchorEvent
import com.hupu.tv.player.app.event.GiftEvent
import com.hupu.tv.player.app.event.MessageEvent
import com.hupu.tv.player.app.event.ReportEvent
import com.hupu.tv.player.app.ui.contact.LiveActivityContact
import com.hupu.tv.player.app.ui.fragment.*
import com.hupu.tv.player.app.ui.presenter.LiveActivityPresenter
import com.hupu.tv.player.app.utils.CommonUtils
import com.hupu.tv.player.app.utils.DialogUtils
import com.hupu.tv.player.app.utils.GlideUtils
import com.hupu.tv.player.app.utils.VersionControl
import com.hupu.tv.player.app.widget.danmuku.DanmakuVideoPlayer
import kotlinx.android.synthetic.main.activity_live.*
import org.greenrobot.eventbus.EventBus
import org.greenrobot.eventbus.Subscribe
import org.greenrobot.eventbus.ThreadMode


class LiveActivity : RefreshActivity<LiveActivityPresenter>(), LiveActivityContact.Display {
    private var roomId = ""
    private var wxNum = ""
    private var qqNum = ""
    private var qqGroupNum = ""
    private var showCopy = false
    private var tvMessage: TextView? = null
    private var customDialog: CustomDialog? = null
    private var orientationUtils: OrientationUtils? = null
    private var mFragment: ArrayList<Fragment> = arrayListOf()
    private var notice = ""
    private var notice2 = ""
    private var isPlay = false
    private var isPause = false
    private var isDestory = false
    private var isFollow = false
    private var LiveRoomUserName = ""
    private var roomCover = ""
    private var matchId = ""
    private var sportType = 0
    var historyList = arrayListOf<HistoryMessageEntity>()
    override fun loadData() {
        presenter?.getHistoryMessage(roomId)
        presenter?.getFakeMessage()
        presenter?.getRoomInfo(roomId)
    }

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override val layoutId: Int
        get() = R.layout.activity_live

    override fun initialize() {
        EventBus.getDefault().register(this)
        setStatusColor(R.color.black)
        roomId = intent.getStringExtra(Constants.ROOM_ID) ?: ""
        roomCover = intent.getStringExtra(Constants.ROOM_COVER) ?: ""
        initView()
//        showCustomDialog()
    }

    private fun showCustomDialog() {
        customDialog = CustomDialog.show(this, R.layout.transient_notification) { dialog, v ->
            tvMessage = v.findViewById(R.id.message)
            addMessage("进入直播间")

        }
        customDialog?.align = BaseDialog.ALIGN.DEFAULT
    }

    private fun initView() {


        ll_follow.onSingleClick {
            if (SPUtil[Constants.USER_LOGIN, false] == true) {
                if (isFollow) {
                    presenter?.unFollowAnchor(roomId)
                } else {
                    presenter?.followAnchor(roomId)
                }
            } else {
                DialogUtils.showLogin(activity as AppCompatActivity)
            }
        }
    }

    private fun initPlayer(fire: String, title: String, url: String) {

        //使用自定义的全屏切换图片，!!!注意xml布局中也需要设置为一样的
        //必须在setUp之前设置
        player.setCover(roomCover)
        player.shrinkImageRes = R.mipmap.icon_custom_shrink
        player.enlargeImageRes = R.mipmap.icon_custom_enlarge

//        player.setUp(url, false, null, null)

        //增加封面
//        val imageView = ImageView(this)
//        imageView.scaleType = ImageView.ScaleType.CENTER_CROP
//        imageView.setImageResource(R.mipmap.xxx1)
//        danmakuVideoPlayer.setThumbImageView(imageView)

//        resolveNormalVideoUI()

        //外部辅助的旋转，帮助全屏

        orientationUtils = OrientationUtils(this, player)
        //初始化不打开外部的旋转
        orientationUtils?.isEnable = false

        player.setIsTouchWiget(true)
        //关闭自动旋转

        player.isRotateViewAuto = false
        player.isLockLand = false
        player.isShowFullAnimation = false
        player.isNeedLockFull = true
        player.isReleaseWhenLossAudio = false

        //detailPlayer.setOpenPreView(true);

        //detailPlayer.setOpenPreView(true);
        player.fullscreenButton.setOnClickListener { //直接横屏
            orientationUtils?.resolveByClick()

            //第一个true是否需要隐藏actionbar，第二个true是否需要隐藏statusbar
            player.startWindowFullscreen(this, true, true)
        }

        player.setVideoAllCallBack(object : GSYSampleCallBack() {
            override fun onPrepared(url: String, vararg objects: Any) {
                super.onPrepared(url, *objects)
                //开始播放了才能旋转和全屏
                orientationUtils?.isEnable = player.isRotateWithSystem
                isPlay = true
            }

            override fun onQuitFullscreen(url: String, vararg objects: Any) {
                super.onQuitFullscreen(url, *objects)
                orientationUtils?.backToProtVideo()
            }
        })

        player.setLockClickListener { view, lock ->
            orientationUtils?.isEnable = !lock
        }
//        val url = "http://129.226.169.250/hszb/#/home"
//        val url = "http://jiaodudesign.cn/198197519-1-208.mp4"
//        player.setUpLazy("http://bf.moonmagic.cn/live/102003.m3u8", false, null, null, title)
        player.setUpLazy(url, false, null, null, title)
        player.startPlayLogic()

        player.setFireText(fire)
        player.setOnBusinessListener(object : DanmakuVideoPlayer.OnBusinessListener {
            override fun onReload() {
                player.currentPlayer.setUpLazy(url, false, null, null, title)
                player.currentPlayer.startPlayLogic()
            }

            override fun back() {
                finish()
            }

            override fun onBusinessStart() {

            }

            override fun onLiveMore() {

            }

            override fun onCopy() {
                if (!TextUtils.isEmpty(wxNum)) {
                    CommonUtils.copy(wxNum, getString(R.string.string_live_copy_success_wx))
                } else if (!TextUtils.isEmpty(qqNum)) {
                    CommonUtils.copy(qqNum, getString(R.string.string_live_copy_success_qq))
                } else if (!TextUtils.isEmpty(qqGroupNum)) {
                    CommonUtils.copy(qqNum, getString(R.string.string_live_copy_success_qq_group))
                }
            }
        })
        player.showCopy(showCopy)
    }

    fun sendDanmu(text: String, isMine: Boolean) {
        (player.currentPlayer as DanmakuVideoPlayer).addDanmaku(text, isMine)
    }

    fun importMessage() {

    }

    private fun initIm(userName: String) {
        EMClient.getInstance().login(userName, "123456", object : EMCallBack {
            override fun onSuccess() {
                runOnUiThread {
                    addMessage("环信登录成功")
                    initTabLayout()
                }
            }

            override fun onProgress(progress: Int, status: String?) {
            }

            override fun onError(code: Int, error: String?) {
                runOnUiThread {
                    if (code == 200) {
                        initTabLayout()
                    } else {
                        initTabLayout(false)
                        addMessage("环信登录失败:code : $code error : $error")
                        if (code == 204) {
                            CommonUtils.copy(userName)
                            addMessage("用户id已经复制到剪切板，请粘贴发送于我，后台注册用户")
                        }
                    }
                }

            }
        })
    }


    private fun initTabLayout(isShowChat: Boolean = true) {
        if (isShowChat) {
            mFragment.add(
                LiveConversationFragment.newInstance(
                    roomId,
                    notice,
                    notice2,
                    LiveRoomUserName
                )
            )
        }

        mFragment.add(LiveAnchorFragment.newInstance(roomId))
        if (VersionControl.showIndex()) {
            mFragment.add(MatchIndexFragment.newInstance(matchId, sportType))
        }

        mFragment.add(MatchAnalysisFragment.newInstance(matchId, sportType))
        mFragment.add(LiveRedListFragment.newInstance(matchId))
//        mFragment.add(LiveMatchFragment.newInstance(roomId))
        val type = when {
            isShowChat && VersionControl.showIndex() -> {
                mTabLayout.tabWidth = 57.6f
                1
            }
            isShowChat && !VersionControl.showIndex() -> {
                mTabLayout.tabWidth = 72f
                2
            }
            !isShowChat && VersionControl.showIndex() -> {
                mTabLayout.tabWidth = 72f
                3
            }
            else -> {
                mTabLayout.tabWidth = 96f
                4
            }
        }

        val mTitles: Array<String?> =
            when (type) {
                //聊天和指数都有
                1 -> arrayOf(
                    getString(R.string.string_live_conversation),
                    getString(R.string.string_live_actor),
                    getString(R.string.string_match_index),
                    getString(R.string.string_match_analysis),
                    getString(R.string.string_live_red_list)
                )
                //聊天有 指数无
                2 -> arrayOf(
                    getString(R.string.string_live_conversation),
                    getString(R.string.string_live_actor),
                    getString(R.string.string_match_analysis),
                    getString(R.string.string_live_red_list)
                )
                //聊天无 指数有
                3 -> arrayOf(
                    getString(R.string.string_live_actor),
                    getString(R.string.string_match_index),
                    getString(R.string.string_match_analysis),
                    getString(R.string.string_live_red_list)
                )
                //聊天无 指数无
                else -> arrayOf(
                    getString(R.string.string_live_actor),
                    getString(R.string.string_match_analysis),
                    getString(R.string.string_live_red_list)
                )
            }
        val mAdapter =
            FragmentBasePager2Adapter(supportFragmentManager, mFragment, mTitles, lifecycle)
        vp_live.adapter = mAdapter
        vp_live.offscreenPageLimit = mFragment.size
        mTabLayout.setViewPager2(vp_live)
        mTabLayout.setOnTabSelectListener(object : OnTabSelectListener {
            override fun onTabSelect(position: Int) {
                vp_live.currentItem = position
            }

            override fun onTabReselect(position: Int) {}
        })
    }


    private fun addMessage(message: String) {
        tvMessage?.text = tvMessage?.text.toString() + "\n" + message
    }

    override fun onRequestRoomInfo(bean: RoomInfoEntity?) {
        CommonUtils.umengJoinLive()
        sportType = bean?.matchInfo?.sportsType ?: 0
        matchId = bean?.matchId ?: ""
        addMessage("请求房间信息成功 直播间 IM userId = ${bean?.huanXinUserId}")
        bean?.let {
            roomId = it.roomId
            notice = it.roomAnnouncement
            notice2 = it.globalAnnouncement.orEmpty()
            if (bean.follow) {
                isFollow = true
                iv_follow.visibility = View.GONE
                tv_follow.text = "已关注"
                ll_follow.background = getDrawable(R.drawable.shape_followed_live)
            } else {
                isFollow = false
                iv_follow.visibility = View.VISIBLE
                tv_follow.text = "关注"
                ll_follow.background = getDrawable(R.drawable.shape_follow_live)
            }
            if (!TextUtils.isEmpty(it.wxNum)) {
                showCopy = true
                wxNum = it.wxNum
                tv_content.text = "主播推荐微信：${it.wxNum}"

            }
            if (!TextUtils.isEmpty(it.qqNum)) {
                showCopy = true
                qqNum = it.qqNum
                tv_content.text = "主播推荐qq：${it.qqNum}"
            }

            if (!TextUtils.isEmpty(it.qqGroupNum)) {
                showCopy = true
                qqGroupNum = it.qqGroupNum
                tv_content.text = "主播推荐qq群：${it.qqGroupNum}"
            }
            val hasContent = qqGroupNum.isNotEmpty() || wxNum.isNotEmpty() || qqNum.isNotEmpty()
            rl_contact.visibility = if (SPUtil[Constants.SHOW_LIVE_CONFIG, false] as Boolean && hasContent) {
                View.VISIBLE
            } else {
                View.GONE
            }

            rl_contact.setOnClickListener {
                when {
                    wxNum.isNotEmpty() -> {
                        CommonUtils.copy(wxNum, getString(R.string.string_live_copy_success_wx))
                        CommonUtils.umengCopyQQNumOrWxNum()
                    }
                    qqNum.isNotEmpty() -> {

                        CommonUtils.copy(qqNum, getString(R.string.string_live_copy_success_qq))
                        CommonUtils.umengCopyQQNumOrWxNum()
                    }
                    qqGroupNum.isNotEmpty() -> {
                        CommonUtils.copy(qqGroupNum, getString(R.string.string_live_copy_success_qq_group))
                        CommonUtils.umengCopyQQNumOrWxNum()
                    }
                }
            }
        }

        if (bean?.roomStatus == 0) {
            iv_live_empty.visibility = View.VISIBLE
            iv_back.visibility = View.VISIBLE
            iv_back.setOnClickListener { finish() }
        } else {
            iv_live_empty.visibility = View.GONE
            initPlayer(bean?.hotNum.toString(), bean?.roomName ?: "", bean?.liveUrl ?: "")
        }
        LiveRoomUserName = bean?.userName ?: ""

        if (VersionControl.isShowLive()) {
            initIm(bean?.huanXinUserId ?: "")
        } else {
            initTabLayout(false)
        }

//        initTabLayoutNoConversation()
    }

    override fun onFollowAnchor(msg: String, status: Boolean) {
        ToastUtil.s(msg)
        if (status) {
            isFollow = true
            iv_follow.visibility = View.GONE
            tv_follow.text = "已关注"
            ll_follow.background = getDrawable(R.drawable.shape_followed_live)
        } else {
            isFollow = false
            iv_follow.visibility = View.VISIBLE
            tv_follow.text = "关注"
            ll_follow.background = getDrawable(R.drawable.shape_follow_live)
        }

        EventBus.getDefault().post(FollowAnchorEvent())

    }

    override fun onSendGift(giftId: Int, position: Int) {
        val list = SPUtil.getSerializableObject<ArrayList<GiftBean>>(Constants.GIFT_BEAN)
        val bean = list?.get(position)
        iv_anim.visibility = View.VISIBLE
        GlideUtils.loadImage(this, bean?.giftImg, iv_anim)
        iv_anim.postDelayed({ iv_anim.visibility = View.GONE }, 2000)
    }

    override fun onHistoryMessage(data: List<HistoryMessageEntity>?) {
        historyList = data as ArrayList<HistoryMessageEntity>
    }

    @Subscribe(threadMode = ThreadMode.MAIN, sticky = true, priority = 1)
    fun onEventDamMu(event: MessageEvent) {
        sendDanmu(event.message, false)
    }

    @Subscribe(threadMode = ThreadMode.MAIN, sticky = true, priority = 1)
    fun onReport(event: ReportEvent) {
        startActivity(Intent(this, ReportActivity::class.java))
    }

    @Subscribe(threadMode = ThreadMode.MAIN, sticky = true, priority = 1)
    fun onEventGift(event: GiftEvent) {
        presenter?.sendGift(event.giftId, roomId, event.giftIndex)
    }


    override fun onBackPressed() {
        orientationUtils?.backToProtVideo()
        if (GSYVideoManager.backFromWindowFull(this)) {
            return
        }
        super.onBackPressed()
    }


    override fun onPause() {
        getCurPlay()?.onVideoPause()
        super.onPause()
        isPause = true
    }

    override fun onResume() {
        getCurPlay()?.onVideoResume()
        super.onResume()
        isPause = false
    }

    override fun onDestroy() {
        super.onDestroy()
        getCurPlay()?.release()
        EMClient.getInstance().chatroomManager().leaveChatRoom(roomId)
        EventBus.getDefault().unregister(this)
        //GSYPreViewManager.instance().releaseMediaPlayer();
        orientationUtils?.releaseListener()
        isDestory = true
    }


    override fun onConfigurationChanged(newConfig: Configuration) {
        super.onConfigurationChanged(newConfig)
        //如果旋转了就全屏
        if (isPlay && !isPause) {
            player.onConfigurationChanged(this, newConfig, orientationUtils, true, true)
        }
    }


    private fun getCurPlay(): GSYVideoPlayer? {
        return if (player.fullWindowPlayer != null) {
            player.fullWindowPlayer
        } else player
    }


    override val ctx: Context?
        get() = this
    override val baseActivity: BaseActivity<*>?
        get() = this


}