package com.hupu.tv.player.app.ui.activity

import android.content.Context
import android.widget.Toast
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.base.IBasePresenter
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.bean.MovieBean
import kotlinx.android.synthetic.main.activity_local_view.*
import java.io.File

/**
 * @author by Dell
 * @date on 2020/7/20
 * @describe
 */
class LocalViewActivity : RefreshActivity<IBasePresenter>() {
    override fun loadData() {

    }

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override val layoutId: Int
        get() = R.layout.activity_local_view

    override fun initialize() {
        val bean = intent?.getSerializableExtra(MovieBean.MOVIE_BEAN) as MovieBean.RecordsBean
        initVideoView(bean.localUrl)
    }

    private fun initVideoView(filePath:String) {
        val file =  File(filePath)
        if (!file.exists()){
            Toast.makeText(this, "视频不存在", Toast.LENGTH_SHORT).show()
            finish()
            return
        }
        video_view.setVideoPath(file.absolutePath)//设置视频文件
        video_view.setOnPreparedListener {
            //视频加载完成,准备好播放视频的回调
        }
        video_view.setOnCompletionListener {
            //视频播放完成后的回调
        }
        video_view.setOnErrorListener { mp, what, extra ->
            false//如果方法处理了错误，则为true；否则为false。返回false或根本没有OnErrorListener，将导致调用OnCompletionListener。
        }
        video_view.setOnInfoListener { mp, what, extra ->
            //信息回调
//                what 对应返回的值如下
//                public static final int MEDIA_INFO_UNKNOWN = 1;  媒体信息未知
//                public static final int MEDIA_INFO_VIDEO_TRACK_LAGGING = 700; 媒体信息视频跟踪滞后
//                public static final int MEDIA_INFO_VIDEO_RENDERING_START = 3; 媒体信息\视频渲染\开始
//                public static final int MEDIA_INFO_BUFFERING_START = 701; 媒体信息缓冲启动
//                public static final int MEDIA_INFO_BUFFERING_END = 702; 媒体信息缓冲结束
//                public static final int MEDIA_INFO_NETWORK_BANDWIDTH = 703; 媒体信息网络带宽（703）
//                public static final int MEDIA_INFO_BAD_INTERLEAVING = 800; 媒体-信息-坏-交错
//                public static final int MEDIA_INFO_NOT_SEEKABLE = 801; 媒体信息找不到
//                public static final int MEDIA_INFO_METADATA_UPDATE = 802; 媒体信息元数据更新
//                public static final int MEDIA_INFO_UNSUPPORTED_SUBTITLE = 901; 媒体信息不支持字幕
//                public static final int MEDIA_INFO_SUBTITLE_TIMED_OUT = 902; 媒体信息字幕超时
            false //如果方法处理了信息，则为true；如果没有，则为false。返回false或根本没有OnInfoListener，将导致丢弃该信息。
        }
    }

    override val ctx: Context?
        get() = this
    override val baseActivity: BaseActivity<*>?
        get() = this
}