package com.hupu.tv.player.app.ui.activity


import android.content.Context
import android.content.Intent
import android.text.Spannable
import android.text.SpannableStringBuilder
import android.text.TextUtils
import android.text.method.HideReturnsTransformationMethod
import android.text.method.LinkMovementMethod
import android.text.style.ClickableSpan
import android.text.style.ForegroundColorSpan
import android.util.Log
import android.view.View
import cc.taylorzhang.singleclick.onSingleClick
import com.kongzue.dialog.v3.WaitDialog
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.utils.CheckUtil
import com.softgarden.baselibrary.utils.ToastUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.event.MessageEvent
import com.hupu.tv.player.app.event.RegisterEvent
import com.hupu.tv.player.app.ui.contact.LoginActivityContact
import com.hupu.tv.player.app.ui.presenter.LoginActivityPresenter
import com.hupu.tv.player.app.utils.CommonUtils
import com.hupu.tv.player.app.utils.DialogUtils
import com.mirkowu.statusbarutil.StatusBarUtil
import com.quanmingxing.app.widget.widget.BiggerDotPasswordTransformationMethod
import com.softgarden.baselibrary.base.BaseActivity
import kotlinx.android.synthetic.main.activity_login.*
import org.greenrobot.eventbus.EventBus
import org.greenrobot.eventbus.Subscribe
import org.greenrobot.eventbus.ThreadMode


class LoginActivity : RefreshActivity<LoginActivityPresenter>(), LoginActivityContact.Display {
    private var phone = ""
    private var code = ""
    private var type = 0
    override val layoutId: Int
        get() = R.layout.activity_login

    override val baseActivity: BaseActivity<*>
        get() = this


    override fun onLoginRequest() {
        intent.getBooleanExtra(Constants.FORCE_EXIT, false)
        WaitDialog.dismiss()
        CommonUtils.umengLogin()
        startActivity(MainActivity::class.java)
        finish()
    }

    override fun onWriteNickName() {
        val intent = Intent(this, NickNameActivity::class.java)
        intent.putExtra(Constants.USER_PHONE, phone)
        intent.putExtra(Constants.USER_CODE, code)
        startActivity(intent)
        finish()
    }

    override val ctx: Context?
        get() = this

    override fun initialize() {
//        cb_agree.isChecked = true
        EventBus.getDefault().register(this)
        Log.e("loginActivity", "initialize")
        initListener()
        initStyle()
        initBottom()
    }

    override fun onResume() {
        super.onResume()
        setStatusTextBlankF5()
    }


    private fun initStyle() {
        et_login_password.transformationMethod = BiggerDotPasswordTransformationMethod()
        iv_show_password.setOnClickListener {
            iv_show_password.isSelected = !iv_show_password.isSelected
            if (iv_show_password.isSelected) {
                et_login_password.transformationMethod = HideReturnsTransformationMethod.getInstance()
            } else {
                et_login_password.transformationMethod = BiggerDotPasswordTransformationMethod()
            }
        }



        codeLogin()
        tv_phone_login.setOnClickListener {
            type = 0
            codeLogin()
        }
        tv_password_login.setOnClickListener {
            type = 1
            passwordLogin()
        }
    }

    private fun codeLogin() {
        tv_password_login.apply {
            setTextColor(getColor(R.color.color_333333))
            paint.isFakeBoldText = false
        }
        tv_phone_login.apply {
            setTextColor(getColor(R.color.color_FC7436))
            paint.isFakeBoldText = true
        }
        ll_code.visibility = View.VISIBLE
        ll_password.visibility = View.GONE

    }

    private fun passwordLogin() {
        tv_phone_login.apply {
            setTextColor(getColor(R.color.color_333333))
            paint.isFakeBoldText = false
        }
        tv_password_login.apply {
            setTextColor(getColor(R.color.color_FC7436))
            paint.isFakeBoldText = true
        }

        ll_code.visibility = View.GONE
        ll_password.visibility = View.VISIBLE


    }


    private fun initBottom() {
        val style = SpannableStringBuilder(getString(R.string.string_user_agreement_title_new))
        val oneSpan = object : ClickableSpan() {
            override fun onClick(widget: View) {
                tv_agreement.highlightColor = resources.getColor(R.color.transparent)
                DialogUtils.showLoginAgreement(
                    this@LoginActivity,
                    getString(R.string.string_user_agreement_title_user),
                    getString(R.string.string_user_agreement)
                )

            }
        }

        val twoSpan = object : ClickableSpan() {
            override fun onClick(widget: View) {
                tv_agreement.highlightColor = resources.getColor(R.color.transparent)
                DialogUtils.showLoginAgreement(
                    this@LoginActivity,
                    getString(R.string.string_user_agreement_title_private),
                    getString(R.string.string_user_private)
                )

            }
        }

        style.setSpan(oneSpan, 12, 16, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE)
        style.setSpan(twoSpan, 19, 23, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE)
        style.setSpan(
            ForegroundColorSpan(getColor(R.color.color_FC7436)),
            12,
            16,
            Spannable.SPAN_EXCLUSIVE_EXCLUSIVE
        )
        style.setSpan(
            ForegroundColorSpan(getColor(R.color.color_FC7436)),
            19,
            23,
            Spannable.SPAN_EXCLUSIVE_EXCLUSIVE
        )
        tv_agreement.movementMethod = LinkMovementMethod.getInstance()
        tv_agreement.text = style
    }

    private fun initListener() {
        iv_back.setOnClickListener {
            onBackPressed()
        }

        tv_register.onSingleClick{
            startActivity(RegisterActivity::class.java)
        }

        tv_forget.onSingleClick {
            startActivity(Intent(this, ForgetPasswordActivity::class.java))
        }

        tv_login.onSingleClick {
            phone = et_login_phone.text.toString()
            code = et_login_code.text.toString()
            if (CheckUtil.isIllegalPhone(phone, "请填入正确的手机号")) {
                return@onSingleClick
            }
            if (type == 0) {
                if (TextUtils.isEmpty(et_login_code.text)) {
                    ToastUtil.s("请填入验证码")
                    return@onSingleClick
                }
            } else {
                if (et_login_password.text.isNullOrEmpty()) {
                    ToastUtil.s("请输入密码")
                    return@onSingleClick
                }
            }

            if (!cb_agree.isChecked) {
                ToastUtil.s("请阅读并同意《用户协议》和《隐私协议》")
            } else {
                if (type == 0) {
                    presenter?.login(phone, "", code, "")
                } else {
                    presenter?.loginPassword(phone, et_login_password.text.toString())
                }
            }

        }
        tv_get_code.onSingleClick {
            phone = et_login_phone.text.toString()
            if (CheckUtil.isIllegalPhone(phone, "请填入正确的手机号")) {
                return@onSingleClick
            }
            presenter?.getSmsCode(phone)
            tv_get_code.start()
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN, sticky = true, priority = 1)
    fun onEventRegister(event: RegisterEvent) {
        onBackPressed()
    }


    override fun onDestroy() {
        super.onDestroy()
        EventBus.getDefault().unregister(this)
    }


    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override fun loadData() {

    }
}