package com.hupu.tv.player.app.ui.activity

import android.content.Context
import android.content.Intent
import android.content.pm.ActivityInfo
import android.content.res.Configuration
import android.view.KeyEvent
import android.widget.ImageView
import androidx.appcompat.app.AppCompatActivity
import androidx.fragment.app.Fragment
import com.flyco.tablayout.CommonTabLayout
import com.flyco.tablayout.listener.CustomTabEntity
import com.flyco.tablayout.listener.OnTabSelectListener
import com.kongzue.dialog.util.DialogSettings
import com.mirkowu.basetoolbar.BaseToolbar
import com.shuyu.gsyvideoplayer.GSYVideoManager
import com.softgarden.baselibrary.base.BaseFragment
import com.softgarden.baselibrary.base.FragmentBasePagerAdapter
import com.softgarden.baselibrary.utils.L
import com.softgarden.baselibrary.utils.SPUtil
import com.softgarden.baselibrary.utils.ToastUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.bean.BannerBean
import com.hupu.tv.player.app.bean.BoardBean
import com.hupu.tv.player.app.bean.TabEntityBean
import com.hupu.tv.player.app.event.RefreshAvatarEvent
import com.hupu.tv.player.app.event.UserExitEvent
import com.hupu.tv.player.app.ui.fragment.*
import com.hupu.tv.player.app.utils.DialogUtils
import com.hupu.tv.player.app.utils.GlideUtils
import com.hupu.tv.player.app.utils.UserHelper
import com.hupu.tv.player.app.utils.VersionControl
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import kotlinx.android.synthetic.main.activity_main2.*
import me.jessyan.autosize.AutoSizeConfig
import org.greenrobot.eventbus.EventBus
import org.greenrobot.eventbus.Subscribe
import org.greenrobot.eventbus.ThreadMode


class MainActivity : RefreshActivity<IBasePresenter>(), IBaseDisplay {
    private lateinit var mainAvatar: ImageView
    private lateinit var haveAvatar: ImageView
    private var oldSelected = 0
    private var mFragment: ArrayList<Fragment> =
        if (VersionControl.showRedList()) {
            arrayListOf(
                MatchFragment.newInstance(),
                MainNewsFragment.newInstance(),
                MainFragment.newInstance(),
                MainHaveMaterialFragment.newInstance(),
                NewMineFragment.newInstance()
            )
        } else {
            arrayListOf(
                MatchFragment.newInstance(),
                MainNewsFragment.newInstance(),
                MainFragment.newInstance(),
                NewMineFragment.newInstance()
            )
        }


    override val layoutId: Int
        get() = R.layout.activity_main2

    override val baseActivity: MainActivity
        get() = this

    fun topMatch() {
        mViewPager.currentItem = 0
        mTabLayout.currentTab = 0
    }

    override val ctx: Context
        get() = this

    override fun initialize() {
        DialogSettings.modalDialog = true
        showAdDialog()
        initTabLayout()
        EventBus.getDefault().register(this)

    }

    @Subscribe(threadMode = ThreadMode.MAIN, sticky = true, priority = 1)
    fun onAvatarEvent(refreshUserEvent: RefreshAvatarEvent?) {
        val userBean = UserHelper.getUserBean()
        if (this::mainAvatar.isInitialized) {
            if (UserHelper.isLogin()) {
                GlideUtils.loadAvatar(this, userBean?.avatarUrl, mainAvatar)
            } else {
                GlideUtils.loadImage(this, R.mipmap.icon_default_avatar, mainAvatar)

            }

        }
        if (this::haveAvatar.isInitialized) {
            if (UserHelper.isLogin()) {
                GlideUtils.loadAvatar(this, userBean?.avatarUrl, haveAvatar)
            } else {
                GlideUtils.loadImage(this, R.mipmap.icon_default_avatar, haveAvatar)

            }
        }

    }


    fun setAvatar(view: ImageView, isMain: Boolean = true) {
        if (isMain) {
            mainAvatar = view
        } else {
            haveAvatar = view
        }
        onAvatarEvent(null)
    }

    private fun showAdDialog() {
        val main = SPUtil.getSerializableObject<ArrayList<BannerBean>>(Constants.MAIN_BANNER)
        if (main?.isNotEmpty() == true) {
            DialogUtils.showAdDialog(this)
        }
    }

    fun toMineFragment() {
        if (UserHelper.isLogin()) {
            if (VersionControl.showRedList()){
                mTabLayout.currentTab = 4
                mViewPager.currentItem = 4
            }else{
                mTabLayout.currentTab = 3
                mViewPager.currentItem = 3
            }


        } else {
            DialogUtils.showLogin(this)
        }
    }


    private fun initStyle() {
        statusBarTranForView(main_background)
    }


    override fun onResume() {
        super.onResume()
        initStyle()
    }

    private fun initTabLayout() {

        val adapter = FragmentBasePagerAdapter(supportFragmentManager, mFragment)
        mViewPager.offscreenPageLimit = mFragment.size
        mViewPager.adapter = adapter
        val mTitles =
            if (VersionControl.showRedList()) {
                arrayOf(
                    getString(R.string.string_main_schedule),
                    getString(R.string.string_main_news),
                    getString(R.string.string_main_home),
                    getString(R.string.string_main_have_material),
                    getString(R.string.string_main_mine)
                )
            } else {
                arrayOf(
                    getString(R.string.string_main_schedule),
                    getString(R.string.string_main_news),
                    getString(R.string.string_main_home),
                    getString(R.string.string_main_mine)
                )
            }


        val mIconUnSelectIds =
            if (VersionControl.showRedList()) {
                intArrayOf(
                    R.mipmap.icon_main_match_nomal,
                    R.mipmap.icon_main_news_normal,
                    R.mipmap.icon_main_live_normal,
                    R.mipmap.icon_main_follow_normal,
                    R.mipmap.icon_main_mine_normal
                )
            } else {
                intArrayOf(
                    R.mipmap.icon_main_match_nomal,
                    R.mipmap.icon_main_news_normal,
                    R.mipmap.icon_main_live_normal,
                    R.mipmap.icon_main_mine_normal
                )
            }


        val mIconSelectIds =
            if (VersionControl.showRedList()) {
                intArrayOf(
                    R.mipmap.icon_main_match_select,
                    R.mipmap.icon_main_news_selected,
                    R.mipmap.icon_main_live_selected,
                    R.mipmap.icon_main_follow_selected,
                    R.mipmap.icon_main_mine_selected
                )
            } else {
                intArrayOf(
                    R.mipmap.icon_main_match_select,
                    R.mipmap.icon_main_news_selected,
                    R.mipmap.icon_main_live_selected,
                    R.mipmap.icon_main_mine_selected
                )
            }

        val mTabEntities = ArrayList<CustomTabEntity>()
        for (i in mTitles.indices) {
            mTabEntities.add(TabEntityBean(mTitles[i], mIconSelectIds[i], mIconUnSelectIds[i]))
        }
        mTabLayout.setTabData(mTabEntities)

        mTabLayout.setOnTabSelectListener(object : OnTabSelectListener {
            override fun onTabSelect(position: Int) {
                val userPosition = if (VersionControl.showRedList()) 4 else 3
                if (position == userPosition) {
                    if (SPUtil[Constants.USER_LOGIN, false] == true) {
                        oldSelected = position
                        mViewPager.currentItem = position
                    } else {
                        mTabLayout.currentTab = oldSelected
                        startActivity(LoginActivity::class.java)
                    }
                } else {
                    oldSelected = position
                    mViewPager.currentItem = position
                }
            }

            override fun onTabReselect(position: Int) {}
        })
        mTabLayout.currentTab = 2
        mViewPager.currentItem = 2


    }

    fun getTabLayout(): CommonTabLayout {
        return mTabLayout
    }

    override fun onPause() {
        super.onPause()
        GSYVideoManager.onPause()
    }


    private fun showBoardDialog() {
        val boardBeanList = SPUtil.getSerializableObject<ArrayList<BoardBean>>(Constants.BOARD_LIST)
        DialogUtils.showMainBoard(
            activity as AppCompatActivity?, boardBeanList?.get(0)?.boardTitle
                ?: "", boardBeanList?.get(0)?.boardContent ?: ""
        )
    }

    /**
     * 检查是否为竖屏
     */
    private fun checkScreenOrientation() {
        if (requestedOrientation != ActivityInfo.SCREEN_ORIENTATION_PORTRAIT) {
            AutoSizeConfig.getInstance().setDesignWidthInDp(360).designHeightInDp = 640
        } else {
            AutoSizeConfig.getInstance().setDesignWidthInDp(640).designHeightInDp = 360
        }
    }

    override fun onConfigurationChanged(newConfig: Configuration) {
        super.onConfigurationChanged(newConfig)
        L.d("onConfigurationChanged调用了")
        checkScreenOrientation()
    }

    @Subscribe(threadMode = ThreadMode.MAIN, sticky = true, priority = 1)
    fun onEventRefreshUser(event: UserExitEvent) {
        mViewPager.currentItem = 2
        mTabLayout.currentTab = 2
    }


    /**
     * 再按一次退出程序
     */
    private var currentBackPressedTime: Long = 0
    override fun dispatchKeyEvent(event: KeyEvent): Boolean {
        if (event.action == KeyEvent.ACTION_DOWN && event.keyCode == KeyEvent.KEYCODE_BACK) {
            val fragment = mFragment[mViewPager.currentItem] as BaseFragment<*>
            if (fragment.onBackPress()) {
                return fragment.onBackPress()
            } else {
                return backApp()
            }

        } else if (event.keyCode == KeyEvent.KEYCODE_MENU) {
            return true
        }
        return super.dispatchKeyEvent(event)
    }

    private fun backApp(): Boolean {
        if (System.currentTimeMillis() - currentBackPressedTime > BACK_PRESSED_INTERVAL) {
            currentBackPressedTime = System.currentTimeMillis()
            ToastUtil.s("再按一次，退出应用！")
            return true
        } else {
            finish() // 退出
        }
        return false
    }

    override fun onDestroy() {
        super.onDestroy()
        EventBus.getDefault().unregister(this)
    }

    companion object {
        fun start(context: Context) {
            val starter = Intent(context, MainActivity::class.java)
            // starter.putExtra(F);
            context.startActivity(starter)
        }

        private const val BACK_PRESSED_INTERVAL = 5000
    }

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override fun loadData() {

    }
}