package com.hupu.tv.player.app.ui.activity

import android.content.Context
import android.content.Intent
import androidx.recyclerview.widget.GridLayoutManager
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.utils.RecyclerViewUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.bean.MatchContentBean.MatchListsBean.MatchInfosBean.GuidesBean
import com.hupu.tv.player.app.bean.MatchDetailBean
import com.hupu.tv.player.app.ui.adapter.LiveMatchItemAdapter
import com.hupu.tv.player.app.ui.contact.MatchDetailContact
import com.hupu.tv.player.app.ui.presenter.MatchDetailPresenter
import com.hupu.tv.player.app.utils.CommonUtils
import com.hupu.tv.player.app.utils.GlideUtils
import kotlinx.android.synthetic.main.activity_match_detail.*


class MatchDetailActivity : RefreshActivity<MatchDetailPresenter>(), MatchDetailContact.Display {
    private var adapter: LiveMatchItemAdapter? = null
    private var id = ""
    override fun loadData() {
        presenter?.getMatchDetail(id)
    }

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override val layoutId: Int
        get() = R.layout.activity_match_detail

    override fun initialize() {
        setStatusColor(R.color.match_detail)
        initRecyclerView()
        iniAdapter()
        initData()
    }

    private fun iniAdapter() {
        mRecyclerView?.layoutManager = GridLayoutManager(this, 2)
        adapter = LiveMatchItemAdapter(R.layout.item_match_live, this)
        mRecyclerView?.adapter = adapter
        mRecyclerView?.let { RecyclerViewUtil.addGridItemDecoration(this, it, R.color.transparent, 2 * Constants.item_divider) }
        adapter?.setOnItemClickListener { adapter, view, position ->
            val guidesBean = adapter.getItem(position) as GuidesBean
            val intent = Intent(activity, LiveActivity::class.java)
            intent.putExtra(Constants.ROOM_ID, guidesBean.roomId)
            intent.putExtra(Constants.ROOM_COVER,guidesBean.matchCutImg)
            startActivity(intent)
        }
    }

    private fun initData() {
        id = intent.getStringExtra(Constants.MATCH_BEAN_ID) ?: ""
        back.setOnClickListener { finish() }

    }

    override fun onMatchDetail(bean: MatchDetailBean?) {
        bean?.let {


          val  time = if (CommonUtils.time == it.matchDate) {
                "今天"
            } else {
                "明天"
            }
            tv_short_name.text = it.matchShortName
            tv_time.text ="$time ${it.matchTime}"
            val homeTeam = it.homeTeam
            val awayTeam = it.awayTeam
            tv_team_name.text = homeTeam.teamName
            tv_team_name_away.text = awayTeam.teamName
            GlideUtils.loadImage(this, homeTeam.teamIcon, iv_team_icon)
            GlideUtils.loadImage(this, awayTeam.teamIcon, iv_team_icon_away)
            it.guides?.let {guides->
                guides.forEach {item->
                    item.sportType = it.sportsType
                }
            }
        }
        adapter?.setNewData(bean?.guides)
    }

    override val ctx: Context?
        get() = this
    override val baseActivity: BaseActivity<*>?
        get() = this

}