package com.hupu.tv.player.app.ui.activity

import android.content.Context
import android.content.Intent
import android.view.KeyEvent
import android.view.View
import android.view.ViewGroup
import android.webkit.*
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import cc.taylorzhang.singleclick.onSingleClick
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.bean.RedDetailEntity
import com.hupu.tv.player.app.bean.RedListData
import com.hupu.tv.player.app.ui.adapter.LabelAdapter
import com.hupu.tv.player.app.ui.adapter.RedDetailAdapter
import com.hupu.tv.player.app.ui.adapter.RedDetailListAdapter
import com.hupu.tv.player.app.ui.adapter.RedLabelAdapter
import com.hupu.tv.player.app.ui.contact.MaterialDetailContact
import com.hupu.tv.player.app.ui.contact.RedDetailContact
import com.hupu.tv.player.app.ui.presenter.MaterialDetailPresenter
import com.hupu.tv.player.app.ui.presenter.RedDetailPresenter
import com.hupu.tv.player.app.utils.CommonUtils
import com.hupu.tv.player.app.utils.DialogUtils
import com.hupu.tv.player.app.utils.GlideUtils
import com.mirkowu.statusbarutil.StatusBarUtil
import com.softgarden.baselibrary.network.ApiException
import com.softgarden.baselibrary.utils.RecyclerViewUtil
import com.softgarden.baselibrary.utils.SPUtil
import com.softgarden.baselibrary.utils.ToastUtil
import kotlinx.android.synthetic.main.activity_material_detial.*
import kotlinx.android.synthetic.main.layout_title.*
import java.util.regex.Matcher
import java.util.regex.Pattern


class MaterialDetailActivity : RefreshActivity<MaterialDetailPresenter>(),
    MaterialDetailContact.Display {
    private var sportId = 0
    private var sportType = 0
    private var isFollow = false
    private var anchorId = ""
    private var score = ""
    private var isOnPause = false
    private lateinit var detailAdapter: RedDetailListAdapter
    override fun loadData() {

        presenter?.getDetail(sportId)
//        presenter?.getAssociate(sportId, mPage)
    }

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override val layoutId: Int
        get() = R.layout.activity_material_detial

    override fun initialize() {
        tv_title_middle.text = "方案详情"
        tv_title_middle.setTextColor(resources.getColor(R.color.black))
        iv_left_icon.setOnClickListener {
            finish()
        }
        sportId = intent.getIntExtra(Constants.RED_DETAIL_ID, 0)
        sportType = intent.getIntExtra(Constants.SPORT_TYPE, 0)
//        initRecyclerView()
        initWebView()
        initListener()
        initStatusLayout(ll_root as View)
        mStatusLayoutManager.showLoadingLayout()

    }

    private fun initListener() {
        ll_follow.onSingleClick {
            if (SPUtil[Constants.USER_LOGIN, false] == true) {
                if (isFollow) {
                    presenter?.cancelFocus(anchorId)
                } else {
                    presenter?.focus(anchorId)
                }
            } else {
                DialogUtils.showLogin(this)
            }

        }
    }


    fun initWebView() {
        // mWebView.setBackgroundColor(ContextCompat.getColor(this, R.color.colorTheme)); // 设置背景色
        val webSettings = mWebView.settings
        mWebView.setBackgroundColor(0)
        //如果访问的页面中要与Javascript交互，则webview必须设置支持Javascript
        webSettings.javaScriptEnabled = true
        //支持插件
        webSettings?.pluginState = WebSettings.PluginState.ON


//        //设置自适应屏幕，两者合用  这样会使加载文本时 文字变小
//        webSettings.setUseWideViewPort(true); //将图片调整到适合webview的大小
//        webSettings.setLoadWithOverviewMode(true); // 缩放至屏幕的大小
        webSettings?.setRenderPriority(WebSettings.RenderPriority.HIGH) //提高渲染的优先级

        //缩放操作
        webSettings?.setSupportZoom(true) //支持缩放，默认为true。是下面那个的前提。
        webSettings?.builtInZoomControls = true //设置内置的缩放控件。若为false，则该WebView不可缩放
        webSettings?.displayZoomControls = false //隐藏原生的缩放控件


        //开启DomStorage缓存
        webSettings?.domStorageEnabled = true
        //        //启用数据库
        webSettings?.databaseEnabled = true
        //        //设置定位的数据库路径
//        String dir = this.getApplicationContext().getDir("database", Context.MODE_PRIVATE).getPath();
//        webSettings.setGeolocationDatabasePath(dir);

        //其他细节操作
        webSettings?.cacheMode = WebSettings.LOAD_NO_CACHE //不使用缓存
        webSettings?.allowFileAccess = true //设置可以访问文件
        webSettings?.javaScriptCanOpenWindowsAutomatically = true //支持通过JS打开新窗口
        webSettings?.loadsImagesAutomatically = true //支持自动加载图片
        webSettings?.defaultTextEncodingName = "utf-8" //设置编码格式
        //支持内容重新布局
        webSettings?.layoutAlgorithm = WebSettings.LayoutAlgorithm.SINGLE_COLUMN

        //这个是加载的地址是https的，一些资源文件使用的是http方法的，
        // 从安卓4.4之后对webview安全机制有了加强，webview里面加载https url的时候，
        // 如果里面需要加载http的资源或者重定向的时候，webview会block页面加载。需要设置MixedContentMode

        webSettings?.mixedContentMode = WebSettings.MIXED_CONTENT_ALWAYS_ALLOW
        mWebView.webChromeClient = object : WebChromeClient() {
            override fun onProgressChanged(view: WebView, newProgress: Int) {
                if (newProgress > 99) {
//                    calculateWeb()
                }
            }
        }
        mWebView.webViewClient = object : WebViewClient() {
            override fun onPageFinished(view: WebView, url: String) {
                super.onPageFinished(view, url)

            }

            override fun shouldOverrideUrlLoading(
                view: WebView?,
                request: WebResourceRequest?
            ): Boolean {
                val url = request?.url?.toString() ?: ""
                startActivity(CommonUtils.toWeb(url))
                mWebView.postDelayed({ finish() }, 1000)
                return true
            }
        }


    }

    override fun onKeyDown(keyCode: Int, event: KeyEvent?): Boolean {
        if (mWebView?.canGoBack() == true) {
            mWebView?.goBack()
            return true
        }
        return super.onKeyDown(keyCode, event)
    }

    /**
     * 当Activity执行onResume()时让WebView执行resume
     */
    override fun onResume() {
        super.onResume()
        try {
            if (isOnPause) {
                mWebView.javaClass.getMethod("onResume").invoke(mWebView, null as Array<Any?>?)
                isOnPause = false
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }


    /**
     * 当Activity执行onPause()时让WebView执行pause
     */
    override fun onPause() {
        super.onPause()
        try {
            mWebView.javaClass.getMethod("onPause").invoke(mWebView, null as Array<Any?>?)
            isOnPause = true
        } catch (e: java.lang.Exception) {
            e.printStackTrace()
        }
    }


    public override fun onDestroy() {
        if (mWebView != null) {
            mWebView.stopLoading()
            mWebView.destroyDrawingCache()
            mWebView.removeAllViews()
            //mWebView.loadDataWithBaseURL(null, "", "text/html", "utf-8", null);
            mWebView.clearHistory()
            mWebView.destroy()

        }
        super.onDestroy()
    }


    /**
     * 方式2：加载html文本
     *
     * @param content
     */
    fun loadText(content: String?) {
        val webSettings = mWebView.settings
        //设置自适应屏幕，两者合用
        val data = cancelStyle(content ?: "")
        val cancelHead = cancelHead(data)
        webSettings?.useWideViewPort = false //将图片调整到适合webview的大小
        webSettings?.loadWithOverviewMode = false // 缩放至屏幕的大小
        /*** 完美自适应屏幕  */
        val sb = StringBuilder()
        sb.append(content)
            .append("<html>")
            .append("<head>")
            .append("<meta charset=\\\"utf-8\\\">")
            .append("<meta id=\\\"viewport\\\" name=\\\"viewport\\\" content=\\\"width=device-width*0.9,initial-scale=1.0,maximum-scale=1.0,user-scalable=false\\\" />")
            .append("<meta name=\\\"apple-mobile-web-app-capable\\\" content=\\\"yes\\\" />")
            .append("<meta name=\\\"apple-mobile-web-app-status-bar-style\\\" content=\\\"black\\\" />")
            .append("<meta name=\\\"black\\\" name=\\\"apple-mobile-web-app-status-bar-style\\\" />")
            .append("<style>img{width:100%;}</style>")
            .append("<style>iframe{width:100%;}</style>")
            .append("<style>table{width:100%;}</style>")
            .append("<style>body{font-size:13px;}</style>")
            .append("<title>mWebView</title>")
        mWebView.loadDataWithBaseURL(null, sb.toString(), "text/html", "utf-8", null)

    }

    private fun cancelStyle(text: String): String {
        var content = text
        // 先把所有的style干掉 - 正则表达式
        val regEx = " style=\"(.*?)\""
        val p: Pattern = Pattern.compile(regEx)
        val m: Matcher = p.matcher(text)
        if (m.find()) {
            content = m.replaceAll("")
        }
        return content;
    }

    private fun replaceImg(content: String): String {
        var temp = content
        val regexHeight = "height:\\d"
        val regexWidth = "width:\\d"
        repeat(4) {
            temp = temp.replace(Regex(regexHeight), "height:")
            temp = temp.replace(Regex(regexWidth), "width:")
        }
        temp = temp.replace("height:px", "height:auto")
        temp = temp.replace("width:px", "width:100%")
        return temp
    }

    private fun cancelHead(text: String): String {
        var content = text
        // 去掉head
        val regEx = ".*[h]1>"
        val p: Pattern = Pattern.compile(regEx)
        val m: Matcher = p.matcher(text)
        if (m.find()) {
            content = m.replaceAll("")
        }
        return content
    }

    override fun onDetail(data: RedDetailEntity?) {
        mStatusLayoutManager.showSuccessLayout()
        data?.let {
//            initAdapter(it)
            tv_title.text = it.title
            iv_win.apply {
                isSelected = it.winOrLose
            }
            tv_name.text = it.anchorName
            tv_time.text = it.releaseTime
            GlideUtils.loadAvatar(this, it.anchorIcon, iv_avatar)
            tv_rate_tag.text = "近${it.sum}中${it.wins}"
            tv_continue_red.text = "${it.continuousWin}选红"
            tv_intro.text = it.anchorDesc
            tv_team_home.text = it.teamInfo?.home?.teamName
            tv_team_away.text = it.teamInfo?.away?.teamName
            GlideUtils.loadImage(this, it.teamInfo?.home?.teamLogo, iv_home_logo)
            GlideUtils.loadImage(this, it.teamInfo?.away?.teamLogo, iv_away_logo)
            recycler_label.apply {
                adapter = RedLabelAdapter().apply {
                    setNewData(it.recentRecord)
                }
                RecyclerViewUtil.addItemDecoration(
                    this@MaterialDetailActivity,
                    this,
                    R.color.transparent,
                    8,
                    RecyclerView.HORIZONTAL
                )
            }

            score = "${it.teamInfo?.home?.score} - ${it.teamInfo?.away?.score}"
            tv_score.text = score
            tv_info.text = "${it.competitionShortName} ${it.matchDay} ${it.matchTime}"
            it.matchOdds?.let { Odd ->
                ll_rate.visibility = View.VISIBLE
                tv_main.text = Odd.wins.toString()
                tv_tie.text = Odd.draw.toString()
                tv_guest.text = Odd.lose.toString()
            }
            tv_type.text = if (it.sportsId?.toInt() ?: 0 == Constants.SPORT_TYPE_FOOTBALL) {
                "竟足"
            } else {
                "竟篮"
            }
            when (it.winPosition) {
                0 -> {
                    ll_main.isSelected = true
                }
                1 -> {
                    ll_tie.isSelected = true
                }
                2 -> {
                    ll_guest.isSelected = true
                }
            }
            isFollow = it.follow
            anchorId = it.anchorId.orEmpty()
            setFollow()
            loadText(it.content)
        }


    }

    private fun setFollow() {
        if (isFollow) {
            iv_follow.visibility = View.GONE
            tv_follow.text = "已关注"
        } else {
            iv_follow.visibility = View.VISIBLE
            tv_follow.text = "关注"
        }
    }

    private fun initAdapter(it: RedDetailEntity) {
        mRecyclerView?.layoutManager = LinearLayoutManager(this, RecyclerView.HORIZONTAL, false)
        val adapter = RedDetailAdapter(R.layout.item_red_detail)
        RecyclerViewUtil.addItemDecoration(
            this,
            mRecyclerView!!,
            R.color.transparent,
            Constants.item_divider_actor,
            RecyclerView.HORIZONTAL
        )
        mRecyclerView?.adapter = adapter
        adapter.setNewData(it.recentRecord)
    }

    override fun onAssociate(data: List<RedListData?>?) {
        setLoadMore(detailAdapter, data)
    }

    override fun onFocus() {
        ToastUtil.s("关注成功")
        isFollow = true
        setFollow()
    }

    override fun onCancelFocus() {
        ToastUtil.s("取消关注成功")
        isFollow = false
        setFollow()
    }


    private fun calculateWeb() {

        //webview加载完成之后重新测量webview的高度
        val layoutParams = mWebView.layoutParams as ViewGroup.LayoutParams
        layoutParams.width = mWebView.width
        layoutParams.height = mWebView.height - nestedScroll.height
        mWebView.layoutParams = layoutParams

    }

    override fun onApiException(t: ApiException) {
        super.onApiException(t)
        mStatusLayoutManager.showErrorLayout()
    }

    override val ctx: Context
        get() = this
    override val baseActivity: BaseActivity<*>
        get() = this

}