package com.hupu.tv.player.app.ui.activity

import android.content.Context
import android.content.Intent
import android.os.Bundle
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.OrientationHelper
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.utils.RecyclerViewUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.bean.MessageBean
import com.hupu.tv.player.app.ui.adapter.MessageAdapter
import com.hupu.tv.player.app.ui.contact.MessagelContact
import com.hupu.tv.player.app.ui.presenter.MessagePresenter
import kotlinx.android.synthetic.main.layout_title.*


class MessageActivity : RefreshActivity<MessagePresenter>(), MessagelContact.Display {
    private var adapter: MessageAdapter? = null
    override fun loadData() {

    }

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override val layoutId: Int
        get() = R.layout.activity_message

    override fun initialize() {
        setStatus()
        tv_title_middle.text = "消息中心"
        iv_left_icon.setOnClickListener {
            finish()
        }
        initRecyclerView()
        initAdapter()
        setData()
    }

    private fun initAdapter() {
        mRecyclerView?.layoutManager = LinearLayoutManager(this)
        adapter = MessageAdapter()
        mRecyclerView?.let {
            RecyclerViewUtil.addItemDecoration(
                this,
                it,
                R.color.view_color,
                5,
                OrientationHelper.VERTICAL
            )
        }
        mRecyclerView?.adapter = adapter
        adapter?.setOnItemClickListener { adapter, view, position ->
            startActivity(Intent(this, MessageDetailActivity::class.java).apply {
                putExtras(Bundle().apply {
                    putSerializable(
                        Constants.MESSAGE_DETAIL,
                        adapter.getItem(position) as MessageBean.DataListBean
                    )
                })
            })
        }
    }

    private fun fakeData(): MutableList<String>? {
        val arrayListOf = arrayListOf<String>()
        arrayListOf.add("文案文案文案文案文案文案文案文案文案文案")
        arrayListOf.add("文案文案文案文案文案文案文案文案文案文案")
        arrayListOf.add("文案文案文案文案文案文案文案文案文案文案")
        arrayListOf.add("文案文案文案文案文案文案文案文案文案文案")
        arrayListOf.add("文案文案文案文案文案文案文案文案文案文案")
        return arrayListOf
    }

    private fun setData() {
        presenter?.getMessage(mPage)
    }

    override fun onMessage(list: List<MessageBean.DataListBean>?) {
        adapter?.let {
            setLoadMore(it, list)
        }

    }


    override val ctx: Context?
        get() = this
    override val baseActivity: BaseActivity<*>?
        get() = this

}