package com.hupu.tv.player.app.ui.activity

import android.content.Context
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.bean.MessageBean
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import kotlinx.android.synthetic.main.activity_message_detail.*
import kotlinx.android.synthetic.main.layout_title.*


class MessageDetailActivity : RefreshActivity<IBasePresenter>(), IBaseDisplay {
    override fun loadData() {

    }

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override val layoutId: Int
        get() = R.layout.activity_message_detail

    override fun initialize() {
        tv_title_middle.text = "消息详情"
        iv_left_icon.setOnClickListener {
            finish()
        }
        initDetail()


    }

    private fun initDetail() {
        intent.extras?.apply {
            (getSerializable(Constants.MESSAGE_DETAIL) as MessageBean.DataListBean).apply {
                tv_title.text = this.title
                tv_time.text = "发布时间：${this.title}"
                tv_content.text = this.content
            }
        }
    }



    override val ctx: Context?
        get() = this
    override val baseActivity: BaseActivity<*>?
        get() = this

}