package com.hupu.tv.player.app.ui.activity

import android.content.Context
import android.content.Intent
import android.text.SpannableStringBuilder
import android.text.Spanned
import android.text.style.ForegroundColorSpan
import android.view.View
import android.view.animation.AnimationUtils
import android.widget.TextView
import androidx.recyclerview.widget.GridLayoutManager
import androidx.recyclerview.widget.LinearLayoutManager
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.utils.RecyclerViewUtil
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.bean.AdBean
import com.hupu.tv.player.app.bean.PayVipTypeBean
import com.hupu.tv.player.app.bean.UserBean
import com.hupu.tv.player.app.ui.adapter.MineVipBuyNewAdapter2
import com.hupu.tv.player.app.ui.adapter.PayAdAdapter
import com.hupu.tv.player.app.ui.contact.MineVipContract
import com.hupu.tv.player.app.ui.presenter.MineVipPresenter
import com.hupu.tv.player.app.utils.CommonUtils
import com.hupu.tv.player.app.utils.DialogUtils
import kotlinx.android.synthetic.main.activity_mine_buy_vip.*
import kotlinx.android.synthetic.main.layout_title.*


/**
 * @author by Dell
 * @date on 2020/6/22
 * @describe
 */
class MineBuyVipActivity : RefreshActivity<MineVipPresenter>(), MineVipContract.Display {
    private var bean: PayVipTypeBean? = null
    override val layoutId: Int
        get() = R.layout.activity_mine_buy_vip


    override fun initialize() {
        setStatus()
        presenter?.requestVipType()
        presenter?.requestRecharge()
        initView()
        setViewData()
        setListener()
    }


    private fun initView() {


//        flipperList.add(flipper)

        tv_title_middle.text = "购买VIP"
        val payAd = AdBean.getPayAd(SPUtil.getSerializableObject<ArrayList<AdBean>>(Constants.AD_LIST))
        val payAdapter = PayAdAdapter(R.layout.pay_ad, payAd, this)
        val linearLayoutManager = LinearLayoutManager(activity)
        RecyclerViewUtil.addItemDecoration(this, recycler_ad, R.color.transparent, Constants.item_divider)
        recycler_ad.layoutManager = RecyclerViewUtil.nestedScrollNoFluent(recycler_ad, linearLayoutManager)
        recycler_ad.adapter = payAdapter
        payAdapter.setOnItemClickListener { adapter, view, position ->
            val item = adapter?.getItem(position) as AdBean
            item?.adUrl?.let {
                startActivity(CommonUtils.toWeb(it))
            }
        }
    }

    private fun initFlipper(data: ArrayList<String>?) {
        view_flipper.removeAllViews()
        for (flipperView in getFlipperView(data)) {
            view_flipper.addView(flipperView)
        }
        view_flipper.startFlipping()
        view_flipper.flipInterval = 4000
        view_flipper.inAnimation = AnimationUtils.loadAnimation(this, R.anim.push_up_in)
        view_flipper.outAnimation = AnimationUtils.loadAnimation(this, R.anim.push_up_out)
    }

    private fun getFlipperView(data: ArrayList<String>?): ArrayList<View> {
        val flipperViews: ArrayList<View> = arrayListOf()

        val colorSpan = ForegroundColorSpan(resources.getColor(R.color.red))
        data?.forEach {
            val view = View.inflate(this, R.layout.item_text_view, null) as TextView
            val split = it.split("：")
            val span = SpannableStringBuilder(it)
            span.setSpan(colorSpan, split[0].length + 1, span.length, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE)
            view.text = span
            flipperViews.add(view)
        }
        return flipperViews;
    }

    private fun setListener() {
        iv_left_icon.setOnClickListener { finish() }
        tv_buy_button.setOnClickListener {
            toPay()
        }
        tv_contact_custom.setOnClickListener {
            if (SPUtil[Constants.CUSTOMER_TYPE, ""] as String == Constants.PLAY_TYPE) {
                startActivity(CommonUtils.toWeb(SPUtil[Constants.CUSTOMER_LINK, ""] as String))
            } else {
                val contract = SPUtil[Constants.CONTRACT, ""] as String
                CommonUtils.copy(contract)
                DialogUtils.showFloatButton(this, object : DialogUtils.OnClickSingleListener {
                    override fun onClick() {
                        CommonUtils.copy(SPUtil[Constants.CONTRACT, ""] as String)
                        if (SPUtil[Constants.CONTRACT_TYPE, ""] as String == Constants.CONTRACT_QQ) {
                            startActivity(CommonUtils.toQQ())
                        } else {
                            startActivity(CommonUtils.toWeChat())
                        }
                    }
                })
            }
        }
    }

    private fun toPay() {
        if (SPUtil[Constants.RECHARGE_TYPE, Constants.RECHARGE_TYPE_APP] as String == Constants.RECHARGE_TYPE_WEB) {
            showPayTipsWebDialog()
        } else {
            //                showPayTipsAppDialog()
            toPayActivity()
        }
    }

    private fun showPayTipsAppDialog() {
        DialogUtils.showPayAppDialog(this, object : DialogUtils.OnClickListener {
            override fun onRightClick(view: View?) {
                toPayActivity()
            }

            override fun onLeftClick(view: View?) {
                startActivity(CommonUtils.toWeb(SPUtil[Constants.YB_URL, ""] as String))
            }
        })
    }

    private fun showPayTipsWebDialog() {
        DialogUtils.showPayWebDialog(this, object : DialogUtils.OnClickListener {
            override fun onRightClick(view: View?) {
                if (SPUtil[Constants.CUSTOMER_TYPE, ""] as String == Constants.PLAY_TYPE) {
                    startActivity(CommonUtils.toWeb(SPUtil[Constants.CUSTOMER_LINK, ""] as String))
                } else {
                    val contract = SPUtil[Constants.CONTRACT, ""] as String
                    CommonUtils.copy(contract)
//                DialogUtils.showMineContactCustom(this@MineBuyVipActivity)
                    DialogUtils.showFloatButton(this@MineBuyVipActivity, object : DialogUtils.OnClickSingleListener {
                        override fun onClick() {
                            CommonUtils.copy(SPUtil[Constants.CONTRACT, ""] as String)
                            if (SPUtil[Constants.CONTRACT_TYPE, ""] as String == Constants.CONTRACT_QQ) {
                                startActivity(CommonUtils.toQQ())
                            } else {
                                startActivity(CommonUtils.toWeChat())
                            }
                        }
                    })
                }
            }

            override fun onLeftClick(view: View?) {
                startActivity(CommonUtils.toWeb(SPUtil[Constants.YB_URL, ""] as String))
            }
        })
    }

    private fun toPayActivity() {
        val intent = Intent(this, PayActivity::class.java)
        intent.putExtra(PayActivity.PAY_NAME, bean?.vipName)
        intent.putExtra(PayActivity.PAY_PRICE, bean?.payMoney.toString())
        intent.putExtra(PayActivity.PAY_ID, bean?.id)
        intent.putExtra(PayActivity.PAY_TYPE, PayActivity.PAY_TYPE_VIP)
        startActivity(intent)
    }

    private fun setViewData() {
        SPUtil.getSerializableObject<UserBean>(Constants.USER_BEAN)?.let {
            tv_user_nick_name.text = it.userName
            if (it.isVip == Constants.IS_VIP) {
                iv_user_head.background = resources.getDrawable(R.mipmap.bg_icon_vip_head)
                tv_vip_time.visibility = View.VISIBLE
                tv_vip_time.text = String.format(getString(R.string.string_user_vip_time), it.endVipTime)
                iv_is_vip.setImageResource(R.mipmap.icon_user_is_vip)
            } else {
                iv_user_head.background = null
                iv_user_head.setFrameColor(resources.getColor(R.color.text_blue))
                tv_vip_time.visibility = View.GONE
                iv_is_vip.setImageResource(R.mipmap.icon_user_is_vip_normal)
            }
        }
    }


    private fun initAdapter(data: ArrayList<PayVipTypeBean>): MineVipBuyNewAdapter2 {
        buy_recycler_view.layoutManager = RecyclerViewUtil.nestedScrollNoFluent(buy_recycler_view, GridLayoutManager(this, 2))
        val mineVipBuyAdapter = MineVipBuyNewAdapter2(R.layout.item_buy_vip_new_new, data, this)
        buy_recycler_view.adapter = mineVipBuyAdapter
        return mineVipBuyAdapter
    }

    private fun setInitData(mineVipBuyNewAdapter2: MineVipBuyNewAdapter2, data: ArrayList<PayVipTypeBean>) {
        mineVipBuyNewAdapter2.bindToRecyclerView(buy_recycler_view)
        buy_recycler_view.post {
//            mineVipBuyNewAdapter2.getViewByPosition(0, R.id.rl_root)?.isSelected = true
//            bean = data[0]
            setTipText()
        }
    }

    private fun setTipText() {
        var watchTime = ""
        var downloadTime = ""
        watchTime = bean?.dayWatchTime.toString()
        if (bean?.dayWatchTime == -1) {
            watchTime = "无限"
        }
        downloadTime = bean?.dayDownloadTime.toString()
        if (bean?.dayDownloadTime == -1) {
            downloadTime = "无限"
        }
        val format = String.format(getString(R.string.string_buy_vip_text), watchTime, downloadTime)
        tv_buy_tips.text = format
    }

    override fun onRequest(data: ArrayList<PayVipTypeBean>?) {
        data?.let {
            val mineVipBuyAdapter = initAdapter(it)
            setInitData(mineVipBuyAdapter, it)
            mineVipBuyAdapter.setOnItemClickListener { adapter, view, position ->
                bean = it[position]
                it.forEach { bean ->
                    bean.isSelected = false
                }
                it[position].isSelected = true
                adapter?.notifyItemRangeChanged(0, it.size, "refresh")
                setTipText()
                if (bean?.timetype == 999){
                    startActivity(CommonUtils.toWeb(SPUtil[Constants.YB_URL,""] as String))
                }else{
                    toPay()
                }

            }
        }

    }

    override fun onRequestRecode(data: ArrayList<String>?) {
        initFlipper(data)
    }


    override val ctx: Context?
        get() = this
    override val baseActivity: BaseActivity<*>?
        get() = this

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override fun loadData() {
    }

}