package com.hupu.tv.player.app.ui.activity

import android.content.Context
import android.view.View
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.bean.UserBean
import kotlinx.android.synthetic.main.activity_mine_vip.*
import kotlinx.android.synthetic.main.layout_title.*

class MineVipActivity : RefreshActivity<IBasePresenter>(), IBaseDisplay {
    override fun loadData() {

    }

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override val layoutId: Int
        get() = R.layout.activity_mine_vip

    override fun initialize() {
        tv_title_middle.text = "我的VIP会员"
        setStatus()
        setViewData()

        setListener()

    }

    private fun setViewData() {
        SPUtil.getSerializableObject<UserBean>(Constants.USER_BEAN)?.let {
            tv_user_nick_name.text = it.userName
            if (it.isVip == Constants.IS_VIP) {
                iv_user_head.background = resources.getDrawable(R.mipmap.bg_icon_vip_head)
                tv_vip_time.visibility = View.VISIBLE
                tv_vip_time.text = String.format(getString(R.string.string_user_vip_time), it.endVipTime)
                iv_is_vip.setImageResource(R.mipmap.icon_user_is_vip)
            } else {
                iv_user_head.background = null
                iv_user_head.setFrameColor(resources.getColor(R.color.text_blue))
                tv_vip_time.visibility = View.GONE
                iv_is_vip.setImageResource(R.mipmap.icon_user_is_vip_normal)
            }
        }
    }

    private fun setListener() {
        iv_left_icon.setOnClickListener { finish() }
    }

    override val ctx: Context?
        get() = this
    override val baseActivity: BaseActivity<*>?
        get() = this
}



