package com.hupu.tv.player.app.ui.activity

import android.content.Context
import android.content.Intent
import android.view.View
import androidx.recyclerview.widget.GridLayoutManager
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.utils.RecyclerViewUtil
import com.softgarden.baselibrary.utils.ToastUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.bean.CoinBean
import com.hupu.tv.player.app.bean.PayVipTypeBean
import com.hupu.tv.player.app.ui.adapter.MineWalletAdapter
import com.hupu.tv.player.app.ui.contact.MineWalletContract
import com.hupu.tv.player.app.ui.presenter.MineWalletPresenter
import kotlinx.android.synthetic.main.activity_mine_wallet.*
import kotlinx.android.synthetic.main.layout_title.*


/**
 * @author by Dell
 * @date on 2020/6/22
 * @describe
 */
class MineWalletActivity : RefreshActivity<MineWalletPresenter>(), MineWalletContract.Display {
    private var bean: CoinBean? = null
    private var mineWalletAdapter: MineWalletAdapter? = null
    private var mPosition = -1
    override val layoutId: Int
        get() = R.layout.activity_mine_wallet


    override fun initialize() {
        setStatus()
        presenter?.requestCoinList()
//        presenter?.requestRecharge()
        initTitle()
        initView()
        setListener()
//        test()
    }

    private fun initTitle() {
        tv_title_middle.text = "金币选择"
        tv_title_right.visibility = View.VISIBLE
        tv_title_right.text = "购买明细"
        tv_title_right.setTextColor(resources.getColor(R.color.bg_red_2))
        tv_title_right.setOnClickListener {
            startActivity(WalletDetailActivity::class.java)
        }
        iv_left_icon.setOnClickListener { finish() }
    }


    private fun initView() {
        tv_money.text = "0.00"
        recycler_wallet.layoutManager = GridLayoutManager(this, 3)
        RecyclerViewUtil.addGridItemDecoration(this, recycler_wallet, R.color.transparent, Constants.item_divider)
        mineWalletAdapter = MineWalletAdapter(R.layout.item_buy_wallet)
        recycler_wallet.adapter = mineWalletAdapter
        mineWalletAdapter?.setOnItemClickListener { adapter, view, position ->
            mPosition= position
            val coinBean = adapter.getItem(position) as CoinBean
            bean = coinBean
            tv_money.text = coinBean.payAmount
            val data = adapter.data as List<CoinBean>
            data.forEach {
                it.isSelected = false
            }
            val item = adapter.getItem(position) as CoinBean
            item.isSelected = true
            adapter.notifyItemRangeChanged(0, data.size, "refresh")
        }


    }

    private fun setListener() {
        tv_confirm.setOnClickListener {
            if(mPosition == -1){
                ToastUtil.s("请选择一个金币付款")
                return@setOnClickListener
            }
            toPayActivity()
        }
    }

    private fun test() {
        //todo 对接接口
        val list: ArrayList<PayVipTypeBean> = arrayListOf()
        for (i in 0..10) {
            val payVipTypeBean = PayVipTypeBean()
            list.add(payVipTypeBean)
        }
//        mineWalletAdapter?.setNewData(list)
    }


    private fun toPayActivity() {
        val intent = Intent(this, PayActivity::class.java)
        intent.putExtra(PayActivity.PAY_NAME, "金币")
        intent.putExtra(PayActivity.PAY_PRICE, bean?.payAmount)
        intent.putExtra(PayActivity.PAY_ID, bean?.id)
        intent.putExtra(PayActivity.PAY_TYPE, PayActivity.PAY_TYPE_COIN)
        startActivity(intent)
    }


    override fun onRequestRecode(data: List<CoinBean>?) {
        mineWalletAdapter?.setNewData(data)
    }


    override val ctx: Context?
        get() = this
    override val baseActivity: BaseActivity<*>?
        get() = this

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override fun loadData() {
    }

}