package com.hupu.tv.player.app.ui.activity

import android.content.Context
import android.view.View
import android.widget.FrameLayout
import androidx.core.content.ContextCompat
import androidx.fragment.app.Fragment
import com.flyco.tablayout.listener.OnTabSelectListener
import com.flyco.tablayout.utils.FragmentBasePager2Adapter
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.base.FragmentBaseStatePagerAdapter
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.bean.*
import com.hupu.tv.player.app.ui.contact.NewMatchDetailContact
import com.hupu.tv.player.app.ui.fragment.*
import com.hupu.tv.player.app.ui.presenter.NewMatchDetailPresenter
import com.hupu.tv.player.app.utils.CommonUtils
import com.hupu.tv.player.app.utils.DialogUtils
import com.hupu.tv.player.app.utils.GlideUtils
import com.hupu.tv.player.app.utils.VersionControl
import com.mirkowu.statusbarutil.StatusBarUtil
import com.softgarden.baselibrary.utils.DisplayUtil
import kotlinx.android.synthetic.main.activity_new_match_detail.*


class NewMatchDetailActivity : RefreshActivity<NewMatchDetailPresenter>(),
    NewMatchDetailContact.Display {
    private var mFragment: ArrayList<Fragment> = arrayListOf()
    private var id = ""
    private var sportType = 0
    private var liveBeanList: List<MatchLiveBean?>? = null
    override fun loadData() {
        if (sportType == Constants.SPORT_TYPE_FOOTBALL) {
            presenter?.getFootBall(id)
            presenter?.getLiveList(id)
        } else {
            presenter?.getBasketBall(id)
        }

    }

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override val layoutId: Int
        get() = R.layout.activity_new_match_detail

    override fun initialize() {
        statusBarTranForView(ll_root_detail, false)
        initData()
        initStatusLayout(ll_root_detail)
        mStatusLayoutManager.showLoadingLayout()
    }

    override fun onFootball(bean: MatchFootballBeanKt?) {
        mStatusLayoutManager.showSuccessLayout()
        initFootBallTabLayout(bean)
        bean?.matchGameInfo?.let {
            val type = if (sportType == Constants.SPORT_TYPE_FOOTBALL) {
                "足球"
            } else {
                "篮球"
            }
            tv_short_name.text = "${type} ${it.competitionShortName}"
            tv_time.text = "${it.matchDay} ${it.matchTime}"
            val homeTeam = it.teamInfo?.homeTeam
            val awayTeam = it.teamInfo?.awayTeam
            tv_team_name.text = homeTeam?.teamName
            tv_team_name_away.text = awayTeam?.teamName
            tv_score.text = "${homeTeam?.score ?: 0} - ${awayTeam?.score ?: 0}"

            GlideUtils.loadImage(
                this,
                homeTeam?.teamLogo,
                iv_team_icon,
                R.mipmap.place_hodler_team_logo_large
            )
            GlideUtils.loadImage(
                this,
                awayTeam?.teamLogo,
                iv_team_icon_away,
                R.mipmap.place_hodler_team_logo_large
            )
            setMatchStatus(it.status)
        }
    }

    private fun setMatchStatus(status: Int?) {
        when (status) {
            2 -> {
                tv_status.background = getDrawable(R.drawable.shape_match_status_not_start)
                tv_status.text = "未开始"
            }
            1 -> {
                tv_status.background = getDrawable(R.drawable.shape_match_status_live)
                tv_status.text = "直播中"
                tv_status.setOnClickListener {
                    DialogUtils.showMatchLive(
                        this,
                        liveBeanList,
                        object : DialogUtils.OnClickTextListener {
                            override fun onClick(text: String) {
                                startActivity(CommonUtils.toWeb(text))
                            }
                        })
                }
            }
            3 -> {
                tv_status.background = getDrawable(R.drawable.shape_match_status_end)
                tv_status.text = "已结束"

//                tv_status.setOnClickListener {
//                    repeat(2){
//                        val arrayList = liveBeanList as ArrayList
//                        arrayList.addAll(arrayList)
//                    }
//                    DialogUtils.showMatchLive(this,liveBeanList, object : DialogUtils.OnClickTextListener {
//                        override fun onClick(text:String) {
//                            startActivity(CommonUtils.toWeb(text))
//                        }
//                    })
//                }
            }
        }
    }

    override fun onMatchLive(data: List<MatchLiveBean?>?) {
        liveBeanList = data
    }

    private fun initFootBallTabLayout(bean: MatchFootballBeanKt?) {

        mFragment.add(MatchFootDataFragment.newInstance(id, bean?.gameStat, bean?.matchGoals))
        mFragment.add(MatchDetailLiveFragment.newInstance(id))
        if (VersionControl.showIndex()) {
            mFragment.add(MatchIndexFragment.newInstance(id, Constants.SPORT_TYPE_FOOTBALL))
        }

        mFragment.add(MatchAnalysisFragment.newInstance(id, sportType))
        mFragment.add(RedListFragment.newInstance(id))
        mFragment.add(MatchNewsFragment.newInstance(id))
        val mTitles: Array<String?> =
            if (VersionControl.showIndex()) {
                arrayOf(
                    getString(R.string.string_match_team),
                    getString(R.string.string_match_live),
                    getString(R.string.string_match_index),
                    getString(R.string.string_match_analysis),
                    getString(R.string.string_live_red_list),
                    getString(R.string.string_main_news)
                )
            } else {
                arrayOf(
                    getString(R.string.string_match_team),
                    getString(R.string.string_match_live),
                    getString(R.string.string_match_analysis),
                    getString(R.string.string_live_red_list),
                    getString(R.string.string_main_news)
                )
            }


        val mAdapter =
            FragmentBasePager2Adapter(supportFragmentManager, mFragment, mTitles, lifecycle)
        vp_match.adapter = mAdapter
        vp_match.offscreenPageLimit = mFragment.size
        mTabLayout.setViewPager2(vp_match)
        mTabLayout.setOnTabSelectListener(object : OnTabSelectListener {
            override fun onTabSelect(position: Int) {
                vp_match.currentItem = position
            }

            override fun onTabReselect(position: Int) {}
        })
    }

    private fun initBasketBallTabLayout(bean: MatchBasketballEntity?) {
        mFragment.add(
            BasketBallTeamFragment.newInstance(
                id,
                bean?.teamMatchInfo?.homeTeam,
                bean?.teamMatchInfo?.awayTeam,
                bean?.homeCompetition,
                bean?.awayCompetition
            )
        )

        mFragment.add(
            BasketBallPlayerFragment.newInstance(
                id,
                bean?.teamMatchInfo?.homeTeam?.teamName ?: "",
                bean?.teamMatchInfo?.awayTeam?.teamName ?: "",
                bean?.homePlayerList,
                bean?.awayPlayerList
            )
        )
        mFragment.add(MatchDetailLiveFragment.newInstance(id))

        mFragment.add(
            MatchAnalysisFragment.newInstance(
                id,
                sportType
            )
        )
        if (VersionControl.showIndex()) {
            mFragment.add(MatchIndexFragment.newInstance(id, Constants.SPORT_TYPE_BASKETBALL))
        }

        mFragment.add(RedListFragment.newInstance(id))
        val mTitles: Array<String?> =
            if (VersionControl.showIndex()) {
                arrayOf(
                    getString(R.string.string_match_team),
                    getString(R.string.string_match_player),
                    getString(R.string.string_match_live),
                    getString(R.string.string_match_analysis),
                    getString(R.string.string_match_index),
                    getString(R.string.string_live_red_list)
                )
            } else {
                arrayOf(
                    getString(R.string.string_match_team),
                    getString(R.string.string_match_player),
                    getString(R.string.string_match_live),
                    getString(R.string.string_match_analysis),
                    getString(R.string.string_live_red_list)
                )
            }

        val mAdapter =
            FragmentBasePager2Adapter(supportFragmentManager, mFragment, mTitles, lifecycle)
        vp_match.adapter = mAdapter
        vp_match.offscreenPageLimit = mFragment.size
        mTabLayout.setViewPager2(vp_match)
        mTabLayout.setOnTabSelectListener(object : OnTabSelectListener {
            override fun onTabSelect(position: Int) {
                vp_match.currentItem = position
            }

            override fun onTabReselect(position: Int) {}
        })
    }


    private fun initData() {
        id = intent.getStringExtra(Constants.MATCH_BEAN_ID) ?: ""
        iv_back.setOnClickListener { finish() }
        sportType = intent.getIntExtra(Constants.SPORT_TYPE, Constants.SPORT_TYPE_FOOTBALL)
    }


    override fun onBasketBall(bean: MatchBasketballEntity?) {
        mStatusLayoutManager.showSuccessLayout()
        initBasketBallTabLayout(bean)

        bean?.teamMatchInfo?.let {
            val type = if (sportType == Constants.SPORT_TYPE_FOOTBALL) {
                "足球"
            } else {
                "篮球"
            }
            tv_short_name.text = "${type} ${it.matchShortName}"
            tv_time.text = "${bean.matchDay} ${bean.matchTime}"
            val homeTeam = it.homeTeam
            val awayTeam = it.awayTeam
            tv_team_name.text = homeTeam?.teamName
            tv_team_name_away.text = awayTeam?.teamName
            tv_score.text = "${homeTeam?.score ?: 0} - ${awayTeam?.score ?: 0}"
            GlideUtils.loadImage(
                this,
                homeTeam?.teamLogo,
                iv_team_icon,
                R.mipmap.place_hodler_team_logo_large
            )
            GlideUtils.loadImage(
                this,
                awayTeam?.teamLogo,
                iv_team_icon_away,
                R.mipmap.place_hodler_team_logo_large
            )
            setMatchStatus(bean.status)

        }


    }


    override val ctx: Context?
        get() = this
    override val baseActivity: BaseActivity<*>?
        get() = this

}